/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl;

import com.day.cq.commons.Language;
import com.day.cq.commons.LanguageUtil;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationUtils {
    private static final Logger logger = LoggerFactory.getLogger(TranslationUtils.class);

    public static String getDestinationLanguageRoot(@Nonnull String srcLanguageRootPath, @Nonnull String destinationLanguage, @Nonnull ResourceResolver resourceResolver) throws RepositoryException {
        Resource resource = resourceResolver.getResource(srcLanguageRootPath);
        if (null != resource) {
            Node node = (Node)resource.adaptTo(Node.class);
            Node parentNode = node.getParent();
            NodeIterator nodeIterator = parentNode.getNodes();
            while (nodeIterator.hasNext()) {
                String language;
                Node currentNode = (Node)nodeIterator.next();
                if (!currentNode.isNodeType("cq:Page") || null == (language = TranslationUtils.getLRLanguageFromNodeProperty(currentNode)) || !language.equals(destinationLanguage)) continue;
                return currentNode.getPath();
            }
            String contentPath = Text.getRelativeParent((String)srcLanguageRootPath, (int)1);
            destinationLanguage = TranslationUtils.getDestinationLanguageWithAllowedDelimiters(contentPath, destinationLanguage, resourceResolver);
            String sameLevelDestinationRootPath = contentPath + "/" + destinationLanguage;
            if (null != resourceResolver.getResource(sameLevelDestinationRootPath)) {
                return sameLevelDestinationRootPath;
            }
            boolean respectContent = true;
            Resource langRootParent = resource.getParent();
            Iterator iter = langRootParent.listChildren();
            while (iter.hasNext()) {
                String retVal;
                Resource sibling = (Resource)iter.next();
                Locale locale = TranslationUtils.getLocaleFromLanguageRootResource(sibling, respectContent);
                if (locale != null || null == (retVal = TranslationUtils.checkAndGetLanguageRootsFromChildren(respectContent, sibling, destinationLanguage))) continue;
                return retVal;
            }
            Resource langRootGrandParent = langRootParent.getParent();
            ArrayList<Resource> nonLangRootUncles = new ArrayList<Resource>();
            boolean additionalLanguageRootsFound = false;
            if (langRootGrandParent != null) {
                Iterator langRootUncles = langRootGrandParent.listChildren();
                while (langRootUncles.hasNext()) {
                    Resource langRootUncle = (Resource)langRootUncles.next();
                    if (langRootUncle.getName().equals(langRootParent.getName())) continue;
                    Locale gcLocale = TranslationUtils.getLocaleFromLanguageRootResource(langRootUncle, respectContent);
                    if (gcLocale != null && !TranslationUtils.isCountryNode(langRootUncle, respectContent)) {
                        additionalLanguageRootsFound = true;
                        String gcLanguage = gcLocale.getLanguage().toString();
                        if (!destinationLanguage.equals(gcLanguage)) continue;
                        return langRootUncle.getPath();
                    }
                    nonLangRootUncles.add(langRootUncle);
                }
            }
            if (additionalLanguageRootsFound) {
                for (Resource nonLangRootUncle : nonLangRootUncles) {
                    String retVal = TranslationUtils.checkAndGetLanguageRootsFromChildren(respectContent, nonLangRootUncle, destinationLanguage);
                    if (null == retVal) continue;
                    return retVal;
                }
            }
            return sameLevelDestinationRootPath;
        }
        return null;
    }

    public static String getLanguageRoot(@Nonnull String path, @Nonnull ResourceResolver resourceResolver) {
        Resource resource = resourceResolver.getResource(path);
        Node node = null;
        if (null != resource) {
            node = (Node)resource.adaptTo(Node.class);
            return TranslationUtils.getLanguageRoot(node);
        }
        return LanguageUtil.getLanguageRoot((String)path);
    }

    public static String getLanguageRoot(@Nonnull Node node) {
        try {
            String languageRootUsingProperty = TranslationUtils.getLanguageRootFromProperty(node);
            if (null != languageRootUsingProperty) {
                return languageRootUsingProperty.equals("") ? null : languageRootUsingProperty;
            }
            return LanguageUtil.getLanguageRoot((String)node.getPath());
        }
        catch (RepositoryException e) {
            logger.error("Cannot find language root.");
            return null;
        }
    }

    private static String getLanguageRootFromProperty(@Nonnull Node node) throws RepositoryException {
        String localeCode = TranslationUtils.getLRLanguageFromNodeProperty(node);
        while (null == localeCode && node.getDepth() != 0) {
            node = node.getParent();
            localeCode = TranslationUtils.getLRLanguageFromNodeProperty(node);
        }
        if (null != localeCode) {
            return LanguageUtil.getLocale((String)localeCode) == null ? "" : node.getPath();
        }
        return null;
    }

    private static String getLRLanguageFromNodeProperty(@Nonnull Node node) throws RepositoryException {
        if (node.hasProperty("jcr:content/cq:isLanguageRoot") && node.getProperty("jcr:content/cq:isLanguageRoot").getBoolean() && node.hasProperty("jcr:content/jcr:language")) {
            return node.getProperty("jcr:content/jcr:language").getString();
        }
        return null;
    }

    private static String getDestinationLanguageWithAllowedDelimiters(@Nonnull String contentPath, @Nonnull String strDestinationLanguage, @Nonnull ResourceResolver resourceResolver) {
        boolean langWithUnderscoreExist;
        String langWithHyphen = strDestinationLanguage.replace("_", "-");
        String langWithUnderscore = strDestinationLanguage.replace("-", "_");
        boolean langWithHyphenExist = null != resourceResolver.getResource(contentPath + "/" + langWithHyphen);
        boolean bl = langWithUnderscoreExist = null != resourceResolver.getResource(contentPath + "/" + langWithUnderscore);
        if (langWithHyphenExist && langWithUnderscoreExist) {
            return strDestinationLanguage;
        }
        if (langWithHyphenExist) {
            return langWithHyphen;
        }
        if (langWithUnderscoreExist) {
            return langWithUnderscore;
        }
        return strDestinationLanguage;
    }

    private static Locale getLocaleFromLanguageRootResource(Resource res, boolean respectContent) {
        Language language;
        block7: {
            if (null == res) {
                return null;
            }
            if (respectContent) {
                Node node = (Node)res.adaptTo(Node.class);
                try {
                    if (!node.hasProperty("jcr:content/jcr:language") || !node.hasProperty("jcr:content/cq:isLanguageRoot") || !node.getProperty("jcr:content/cq:isLanguageRoot").getBoolean()) break block7;
                    String iso = node.getProperty("jcr:content/jcr:language").getString();
                    Language language1 = LanguageUtil.getLanguage((String)iso);
                    if (language1 == null) {
                        logger.warn("Invalid iso code stored in {}: {}", (Object)node.getPath(), (Object)iso);
                        break block7;
                    }
                    return language1.getLocale();
                }
                catch (AccessDeniedException e) {
                    logger.warn("The current session does not have sufficent access to retrieve the parent of this item.", (Throwable)e);
                }
                catch (RepositoryException e) {
                    logger.warn("Error while retrieving language property.", (Throwable)e);
                }
            }
        }
        if ((language = LanguageUtil.getLanguage((String)res.getName())) != null) {
            return language.getLocale();
        }
        return null;
    }

    private static String checkAndGetLanguageRootsFromChildren(boolean respectContent, Resource resource, String destLanguage) {
        Iterator children = resource.listChildren();
        while (children.hasNext()) {
            String childLanguage;
            Resource child = (Resource)children.next();
            Locale childLocale = TranslationUtils.getLocaleFromLanguageRootResource(child, respectContent);
            if (childLocale == null || !TranslationUtils.isLanguageSameWithAllowedDelimiters(childLanguage = childLocale.toString(), destLanguage)) continue;
            return child.getPath();
        }
        return null;
    }

    private static boolean isLanguageSameWithAllowedDelimiters(@Nonnull String lang1, @Nonnull String lang2) {
        return StringUtils.equalsIgnoreCase((CharSequence)lang1, (CharSequence)lang2) || lang1.replace("_", "-").equalsIgnoreCase(lang2.replace("_", "-")) || lang1.replace("-", "_").equalsIgnoreCase(lang2.replace("-", "_"));
    }

    private static boolean isCountryNode(Resource resource, boolean respectContent) {
        Iterator children = resource.listChildren();
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            Locale gcLocale = TranslationUtils.getLocaleFromLanguageRootResource(child, respectContent);
            if (gcLocale == null) continue;
            return true;
        }
        return false;
    }
}

