/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.smartling.aem.connector.automation.impl.related.AssetNodeRule;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsConfiguration;
import com.smartling.aem.connector.automation.impl.related.RelatedAssetsException;
import com.smartling.aem.connector.automation.impl.related.TranslatableNode;
import com.smartling.aem.connector.automation.impl.related.TranslatableNodeType;
import com.smartling.aem.connector.automation.impl.related.TranslationRuleProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedAssetsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedAssetsManager.class);
    public static final String DAM_ASSET = "dam:Asset";
    public static final String CQ_PAGE = "cq:Page";
    public static final String JCR_CONTENT = "jcr:content";
    private static final int MAX_REFERENCED_TRANSLATION_OBJECTS_DEEP = 20;
    private static final int MAX_CONTENT_COMPONENTS_DEEP = 20;
    private final ResourceResolver resourceResolver;
    private final RelatedAssetsConfiguration configuration;
    private final TranslationRuleProvider translationRuleProvider;

    public RelatedAssetsManager(ResourceResolver resourceResolver, TranslationRuleProvider translationRuleProvider, RelatedAssetsConfiguration configuration) {
        this.resourceResolver = resourceResolver;
        this.translationRuleProvider = translationRuleProvider;
        this.configuration = configuration;
    }

    public List<String> getRelatedAssets(String languageCopyPath) throws RelatedAssetsException {
        Resource pageResource = this.resourceResolver.getResource(languageCopyPath);
        if (pageResource == null) {
            throw new RelatedAssetsException(String.format("Couldn't get access to resource path=\"%s\"", languageCopyPath));
        }
        TranslatableNode pageNode = (TranslatableNode)pageResource.adaptTo(TranslatableNode.class);
        HashSet<TranslatableNode> outputNodeList = new HashSet<TranslatableNode>();
        outputNodeList.add(pageNode);
        try {
            Collection<TranslatableNode> addedNodes = this.addTranslationObjects(outputNodeList);
            return this.excludeSourcePath(addedNodes, languageCopyPath);
        }
        catch (IOException | RepositoryException e) {
            throw new RelatedAssetsException(String.format("Couldn't search related assets for path=\"%s\"", languageCopyPath));
        }
    }

    private List<String> excludeSourcePath(Collection<TranslatableNode> outputNodeList, String languageCopyPath) {
        return outputNodeList.stream().map(translatableNode -> {
            try {
                return translatableNode.getPath();
            }
            catch (RepositoryException e) {
                LOGGER.error("Couldn't get related assets for languageCopyPath=\"{}\"", (Object)languageCopyPath, (Object)e);
                return null;
            }
        }).filter(StringUtils::isNotBlank).filter(path -> !StringUtils.equalsIgnoreCase((CharSequence)path, (CharSequence)languageCopyPath)).collect(Collectors.toList());
    }

    private List<TranslatableNode> getAssetListFromPage(TranslatableNode currentNode) throws RepositoryException, IOException, RelatedAssetsException {
        ArrayList<TranslatableNode> assetList = new ArrayList<TranslatableNode>();
        for (TranslatableNode childNode : currentNode.getChildNodes()) {
            this.getAssetListFromNode(childNode, assetList);
        }
        return assetList;
    }

    private void getAssetListFromNode(TranslatableNode currentNode, ArrayList<TranslatableNode> assetList) throws RepositoryException, IOException, RelatedAssetsException {
        if (!currentNode.isPageNode()) {
            AssetNodeRule assetRule;
            String strAssetPath = null;
            String strResourceType = currentNode.getNodeResourceType();
            if (StringUtils.isNotBlank((CharSequence)strResourceType) && (assetRule = this.translationRuleProvider.getAssetNodeFileRule(strResourceType)) != null) {
                String strFileAttributeName = assetRule.getStrFileReferenceAttribute();
                if (StringUtils.isNotBlank((CharSequence)strFileAttributeName)) {
                    strAssetPath = currentNode.getStringAttribute(strFileAttributeName);
                }
                if (StringUtils.isBlank(strAssetPath)) {
                    TranslatableNode binaryNode = currentNode.getBinaryNode();
                    if (binaryNode != null) {
                        assetList.add(binaryNode);
                    }
                } else {
                    String strNodePrimaryType;
                    TranslatableNode assetNode;
                    Resource assetResource = this.resourceResolver.getResource(strAssetPath);
                    if (assetResource != null && (assetNode = (TranslatableNode)assetResource.adaptTo(TranslatableNode.class)) != null && DAM_ASSET.equals(strNodePrimaryType = assetNode.getNodePrimaryType())) {
                        assetList.add(assetNode);
                        if (assetNode.isContentFragment()) {
                            if (this.configuration.isTranslateAssociatedContentForAssets()) {
                                this.addContentFragmentAssociatedContent(assetNode, assetList);
                            }
                            if (this.configuration.isTranslateInlineMediaAssets()) {
                                this.addContentFragmentEmbeddedAssets(assetNode, assetList);
                            }
                        }
                        return;
                    }
                }
            }
            for (TranslatableNode childNode : currentNode.getChildNodes()) {
                this.getAssetListFromNode(childNode, assetList);
            }
        }
    }

    private void addContentFragmentAssociatedContent(TranslatableNode contentFragmentNode, ArrayList<TranslatableNode> assetList) throws RepositoryException {
        List<TranslatableNode> destinationAssetList = contentFragmentNode.getContentFragmentAssociatedAssets(this.resourceResolver);
        assetList.addAll(destinationAssetList);
    }

    private void addContentFragmentEmbeddedAssets(TranslatableNode contentFragmentNode, ArrayList<TranslatableNode> assetList) throws RepositoryException, IOException {
        List<TranslatableNode> destinationAssetList = contentFragmentNode.getEmbeddedAssets(this.resourceResolver);
        assetList.addAll(destinationAssetList);
    }

    private Collection<TranslatableNode> addTranslationObjects(Collection<TranslatableNode> nodeList) throws RepositoryException, IOException, RelatedAssetsException {
        HashSet<TranslatableNode> addedObjects = new HashSet<TranslatableNode>();
        HashSet<TranslatableNode> resultObjects = new HashSet<TranslatableNode>(nodeList);
        boolean checkForEmbeddedAssets = this.configuration.checkForEmbeddedAssets();
        Collection<TranslatableNode> cycleObjects = new HashSet<TranslatableNode>(nodeList);
        int cycleCount = 0;
        while (!cycleObjects.isEmpty() && cycleCount++ < 20) {
            for (TranslatableNode newObj : cycleObjects) {
                if (newObj.getType() != TranslatableNodeType.PAGE) continue;
                ArrayList<TranslatableNode> pageList = this.getReferencedPageListFromPage(newObj);
                addedObjects.addAll(pageList);
                if (!this.configuration.checkAssets()) continue;
                Collection assetList = this.getAssetListFromPage(newObj).stream().filter(asset -> checkForEmbeddedAssets || asset.isContentFragment()).collect(Collectors.toSet());
                addedObjects.addAll(assetList);
            }
            cycleObjects = this.subtract(addedObjects, resultObjects);
            resultObjects.addAll(addedObjects);
            addedObjects = new HashSet();
        }
        return resultObjects;
    }

    private Collection<TranslatableNode> subtract(Collection<TranslatableNode> minuend, Collection<TranslatableNode> subtrahend) {
        return CollectionUtils.subtract(minuend, subtrahend);
    }

    private ArrayList<TranslatableNode> getReferencedPageListFromPage(TranslatableNode currentNode) throws RepositoryException, RelatedAssetsException {
        ArrayList<TranslatableNode> assetList = new ArrayList<TranslatableNode>();
        for (TranslatableNode childNode : currentNode.getChildNodes()) {
            this.getPageListFromNodeTraverse(childNode, assetList);
        }
        return assetList;
    }

    private void getPageListFromNodeTraverse(TranslatableNode currentNode, ArrayList<TranslatableNode> assetList) throws RepositoryException, RelatedAssetsException {
        HashSet<TranslatableNode> totalNodes = new HashSet<TranslatableNode>(Collections.singleton(currentNode));
        Collection<TranslatableNode> cycleNodes = new HashSet<TranslatableNode>(Collections.singleton(currentNode));
        HashSet<TranslatableNode> newNodes = new HashSet<TranslatableNode>();
        int cycleCount = 0;
        while (!cycleNodes.isEmpty() && cycleCount++ < 20) {
            for (TranslatableNode cycleNode : cycleNodes) {
                this.getPageListFromNode(cycleNode, assetList);
                if (cycleNode.isPageNode()) continue;
                for (TranslatableNode childNode : cycleNode.getChildNodes()) {
                    newNodes.add(childNode);
                }
            }
            cycleNodes = this.subtract(newNodes, totalNodes);
            totalNodes.addAll(newNodes);
            newNodes = new HashSet();
        }
    }

    private void getPageListFromNode(TranslatableNode currentNode, ArrayList<TranslatableNode> assetList) throws RepositoryException, RelatedAssetsException {
        String strFileAttributeName;
        AssetNodeRule assetRule;
        String strResourceType;
        if (!currentNode.isPageNode() && StringUtils.isNotBlank((CharSequence)(strResourceType = currentNode.getNodeResourceType())) && (assetRule = this.translationRuleProvider.getAssetNodeFileRule(strResourceType)) != null && !StringUtils.isEmpty((CharSequence)(strFileAttributeName = assetRule.getStrFileReferenceAttribute()))) {
            List<String> strPagePaths = currentNode.getStringListAttribute(strFileAttributeName);
            for (String strPagePath : strPagePaths) {
                String strNodePrimaryType;
                TranslatableNode pageNode;
                Resource pageResource = this.resourceResolver.getResource(strPagePath);
                if (pageResource == null || (pageNode = (TranslatableNode)pageResource.adaptTo(TranslatableNode.class)) == null || !CQ_PAGE.equals(strNodePrimaryType = pageNode.getNodePrimaryType()) || !this.translationRuleProvider.canTranslateNode(pageNode)) continue;
                assetList.add(pageNode);
            }
        }
    }
}

