/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.project;

import com.adobe.granite.translation.api.TranslationConstants;
import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationObject;
import com.smartling.aem.connector.automation.impl.wcm.project.ResourcePredicates;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationObjectResource;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.EnumUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;

class TranslationJobResource
implements TranslationJob {
    private static final String TRANSLATION_STATUS_PROP = "translationStatus";
    private static final String CURRENT_POLLER_ACTION_PROP = "currentPollerAction";
    private static final String TARGET_LANGUAGE_PROP = "destinationLanguage";
    private static final String JOB_ID_PROP = "translationObjectID";
    static final String RESOURCE_TYPE = "cq/gui/components/projects/admin/pod/translationjobpod";
    private final Resource resource;
    private final ModifiableValueMap translationJobProperties;

    TranslationJobResource(Resource resource) {
        this.resource = resource;
        this.translationJobProperties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
    }

    @Override
    public TranslationConstants.TranslationStatus getStatus() {
        String translationStatus = (String)this.translationJobProperties.get(TRANSLATION_STATUS_PROP, String.class);
        return (TranslationConstants.TranslationStatus)EnumUtils.getEnum(TranslationConstants.TranslationStatus.class, (String)translationStatus);
    }

    @Override
    public Collection<TranslationObject> getTranslationObjects() {
        Resource translationObjectsRootResource = this.resource.getChild("child_pages");
        if (translationObjectsRootResource == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(translationObjectsRootResource.getChildren().spliterator(), false).filter(ResourcePredicates.hasResourceType("cq/gui/components/projects/admin/card/translation_object")).map(TranslationObjectResource::new).collect(Collectors.toList());
    }

    @Override
    public String getCurrentPollerAction() {
        return (String)this.translationJobProperties.get(CURRENT_POLLER_ACTION_PROP, String.class);
    }

    @Override
    public void setCurrentPollerAction(String action) {
        this.translationJobProperties.put((Object)CURRENT_POLLER_ACTION_PROP, (Object)action);
    }

    @Override
    public String getResourcePath() {
        return this.resource.getPath();
    }

    @Override
    public String getTargetLanguage() {
        return (String)this.translationJobProperties.get(TARGET_LANGUAGE_PROP, String.class);
    }

    @Override
    public String getJobId() {
        return (String)this.translationJobProperties.get(JOB_ID_PROP, String.class);
    }
}

