/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.exec.WorkItem;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DetermineTargetLocalesProcess
extends ContextAwareWorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetermineTargetLocalesProcess.class);
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String INFO_MESSAGE = "infoMessage";

    protected void putTargetLocales(WorkItem workItem, Set<String> supportedLocales, StringBuilder skipUpToDateLocalesMessage, StringBuilder skipNonValidConfigMessage) {
        Object[] filtered = supportedLocales.toArray(new String[supportedLocales.size()]);
        workItem.getWorkflowData().getMetaDataMap().remove((Object)"targetLocaleCodes");
        workItem.getWorkflowData().getMetaDataMap().put((Object)"targetLocaleCodes", (Object)filtered);
        String fullMessage = StringUtils.trim((String)(skipUpToDateLocalesMessage.toString() + " " + skipNonValidConfigMessage.toString()));
        if (filtered.length > 0) {
            this.setInfoMessage(workItem, fullMessage);
            LOGGER.debug("Using target locales: {}", (Object)Arrays.toString(filtered));
        } else {
            this.setErrorMessage(workItem, fullMessage);
        }
    }

    protected Set<String> getActualLocales(ResourceResolver resourceResolver, LanguageCopyManager languageCopyManager, SmartlingCloudConfig cloudConfig, Resource sourceResource, Set<String> targetLocales, StringBuilder skipUpToDateLocalesMessage) {
        Iterable<LanguageCopyManager.LanguageCopy> languageCopies = languageCopyManager.findLanguageCopies(resourceResolver, sourceResource.getPath());
        Set outdatedLanguageCopyLocales = StreamSupport.stream(languageCopies.spliterator(), false).filter(copy -> targetLocales.contains(copy.getLanguage().getCode())).filter(this.updatedBefore(resourceResolver, languageCopyManager, sourceResource)).map(DetermineTargetLocalesProcess.toLocaleCode()).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
        Collection actualLocales = CollectionUtils.intersection(targetLocales, (Collection)outdatedLanguageCopyLocales);
        Collection unusedLocales = CollectionUtils.subtract(targetLocales, (Collection)actualLocales);
        if (unusedLocales.size() > 0) {
            LOGGER.warn("Locales \"{}\" will not be used for translation", (Object)StringUtils.join((Iterable)unusedLocales, (String)";"));
        }
        skipUpToDateLocalesMessage.append(this.validateLocaleCodes("The same source content has already been submitted for %s languages to Smartling. You must make a change to source content \"" + sourceResource.getPath() + "\" before submitting to Smartling again.", targetLocales, outdatedLanguageCopyLocales, cloudConfig.getProjectId()));
        return outdatedLanguageCopyLocales;
    }

    protected Set<String> getSupportedLocales(String sourceLocale, SmartlingCloudConfig cloudConfig, Set<String> targetLocales, StringBuilder skipNonValidConfigMessage) throws WorkflowException {
        Set<String> supported = this.filterOnlySupportedLocales(cloudConfig, sourceLocale, targetLocales);
        skipNonValidConfigMessage.append(this.validateLocaleCodes("Languages %s, have no language mapping or do not have corresponding language in Smartling project.", targetLocales, supported, cloudConfig.getProjectId()));
        return supported;
    }

    private Set<String> filterOnlySupportedLocales(SmartlingCloudConfig cloudConfig, String sourceLocale, Collection<String> outDatedLocales) throws WorkflowException {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String localeCode : outDatedLocales) {
            try {
                if (!cloudConfig.isDirectionSupported(sourceLocale, localeCode)) continue;
                result.add(localeCode);
            }
            catch (SmartlingException e) {
                LOGGER.error("Failed to verify translation direction support {} -> {}: ", new Object[]{sourceLocale, localeCode, e});
                throw new WorkflowException(String.format("Failed to verify translation direction support %s -> %s", sourceLocale, localeCode), (Throwable)e);
            }
        }
        return result;
    }

    private Predicate<LanguageCopyManager.LanguageCopy> updatedBefore(ResourceResolver resourceResolver, LanguageCopyManager languageCopyManager, Resource resource) {
        return languageCopy -> languageCopyManager.isSourceChangedAfterTranslation(resourceResolver, resource.getPath(), languageCopy.getPath());
    }

    private static Function<LanguageCopyManager.LanguageCopy, String> toLocaleCode() {
        return languageCopy -> languageCopy.getLanguage().getCode();
    }

    private String validateLocaleCodes(String cause, Collection<String> intended, Collection<String> actual, String projectId) {
        Collection diff = CollectionUtils.subtract(intended, actual);
        if (!diff.isEmpty() && !intended.isEmpty()) {
            String message = String.format(cause, diff);
            LOGGER.warn(message);
            return String.format("There was an issue submitting content for %s (project=%s).", intended, projectId) + " " + message;
        }
        return "";
    }
}

