/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.integration.platform.InboxNotificationService;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowProcess.class})
public class NotifyOnCompletionProcess
extends ContextAwareWorkflowProcess
implements WorkflowProcess {
    @Reference
    private InboxNotificationService notificationService;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        JobWorkflowParameters parameters = new JobWorkflowParameters(workItem);
        SmartlingCloudConfig config = this.getSmartlingCloudConfig(workItem, workflowSession);
        String possibleIssuesMessage = this.getErrorMessage(workItem);
        String infoMessage = this.getInfoMessage(workItem);
        String submitMessage = String.format("Content successfully submitted to Smartling. You can find it here: https://dashboard.smartling.com/app/projects/%s/jobs/%s", config.getProjectId(), parameters.getJobUid());
        submitMessage = StringUtils.isNotEmpty((CharSequence)infoMessage) ? submitMessage + " " + infoMessage : submitMessage;
        String message = StringUtils.isEmpty((CharSequence)possibleIssuesMessage) ? submitMessage : possibleIssuesMessage + " " + submitMessage;
        String sourcePaths = StringUtils.join(parameters.getSourcePathList(), (String)";");
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        this.notificationService.sendNotification(resourceResolver, "Smartling: Content was submitted", message, sourcePaths);
    }

    @Override
    protected boolean shouldExecute(WorkItem workItem) {
        return this.isExecutedFirstTime(workItem);
    }
}

