/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.SendForTranslationProcess;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.core.Predicates;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class})
public class SendAssetForTranslationProcess
extends SendForTranslationProcess
implements WorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendAssetForTranslationProcess.class);
    @Reference
    private AssetLanguageCopyManager languageCopyManager;
    @Reference
    private WcmWorkflows wcmWorkflows;

    @Override
    public void updateLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        this.wcmWorkflows.prepareAssetLanguageCopy(workflowSession, parameters);
    }

    @Override
    protected void putCustomWorkflowParams(WcmWorkflows.Parameters parameters, ResourceResolver resourceResolver, WorkItem workItem) {
        JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
        Language sourceLanguage = this.languageCopyManager.getLanguage(resourceResolver, workflowParameters.getSourcePathList().get(0));
        List<LanguageCopyManager.LanguageCopy> languageCopies = workflowParameters.getSourcePathList().stream().flatMap(sourcePath -> this.getLanguageCopies(resourceResolver, (Collection<String>)workflowParameters.getTargetLocaleCodes(), (String)sourcePath).stream()).collect(Collectors.toList());
        parameters.setInitiatorUserID(workItem.getWorkflow().getInitiator());
        parameters.setSourcePaths(workflowParameters.getSourcePathList());
        parameters.setSourceLanguage(sourceLanguage.getCode());
        parameters.setLanguageCopies(languageCopies);
    }

    private List<LanguageCopyManager.LanguageCopy> getLanguageCopies(ResourceResolver resourceResolver, Collection<String> targetLocales, String sourcePath) {
        List<LanguageCopyManager.LanguageCopy> languageCopies = StreamSupport.stream(this.languageCopyManager.findLanguageCopies(resourceResolver, sourcePath).spliterator(), false).filter(WorkflowUtil.byLocaleCode(Predicates.in(targetLocales))).collect(Collectors.toList());
        List nonExisted = languageCopies.stream().filter(languageCopy -> !languageCopy.exists()).map(LanguageCopyManager.LanguageCopy::getPath).collect(Collectors.toList());
        if (nonExisted.isEmpty()) {
            return languageCopies;
        }
        LOGGER.warn("These content=\"{}\" is not existed, so it will not be requested for translation.", (Object)String.join((CharSequence)";", nonExisted));
        return languageCopies.stream().filter(LanguageCopyManager.LanguageCopy::exists).collect(Collectors.toList());
    }
}

