/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.commons.jcr.JcrUtil;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationProjectCreateOptions;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClient;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClientFactory;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SendForTranslationProcess
extends ContextAwareWorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendForTranslationProcess.class);
    public static final String CREATE_BATCH_EXCEPTION_MESSAGE_FORMAT = "Error during creating batch for jobUid=\"%s\" projectId=\"%s\":";
    public static final String NO_SMARTLING_CLOUD_CONFIG_FOUND_MESSAGE = "No Smartling cloud config found for site";
    public static final String NO_TRANSLATION_INTEGRATION_CLOUD_CONFIG_FOUND_MESSAGE = "No Translation Integration cloud config found for site";
    public static final String FAILED_TO_CREATE_TRANSLATION_PROJECT_FOLDER_MESSAGE = "Failed to create translation project folder";
    public static final String AUTOEXECUTE_DISABLED_FOR_SITE_MESSAGE = "Auto-execute translation should be enabled for site";
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Reference
    protected TranslationProjectManager translationProjectManager;
    @Reference
    protected SmartlingPlatformClientFactory smartlingPlatformClientFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        try {
            String folderPath;
            Resource resource = this.getPayloadResource(workItem, workflowSession);
            JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
            this.getMandatoryCloudConfig(resource, SmartlingCloudConfig.class, NO_SMARTLING_CLOUD_CONFIG_FOUND_MESSAGE);
            MachineTranslationCloudConfig translationCloudConfig = this.getMandatoryCloudConfig(resource, MachineTranslationCloudConfig.class, NO_TRANSLATION_INTEGRATION_CLOUD_CONFIG_FOUND_MESSAGE);
            if (!translationCloudConfig.isAutoExecuteTranslationWorkflowForSites()) {
                LOGGER.error("Failed to start translation for resource {}: auto-execution is disabled", (Object)resource.getPath());
                throw new WorkflowException(AUTOEXECUTE_DISABLED_FOR_SITE_MESSAGE);
            }
            String payloadTitle = StringUtils.trim((String)WorkflowUtil.getPayloadTitle(resource));
            String title = workflowParameters.getJobName().map(Optional::of).orElse(Optional.ofNullable(payloadTitle)).orElse(resource.getName());
            String jobUid = workflowParameters.getJobUid();
            String sourceLocaleCode = workflowParameters.getConfigSourceLocaleCode();
            SmartlingCloudConfig sourceCloudConfig = this.getSmartlingCloudConfig(workItem, workflowSession);
            String batchUid = this.createBatch(jobUid, workflowParameters.shouldAuthorizeJob(), sourceCloudConfig);
            ResourceResolver projectManagerResourceResolver = null;
            try {
                projectManagerResourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
                TranslationProjectCreateOptions options = TranslationProjectCreateOptions.builder().title(StringUtils.trim((String)title)).jobUid(jobUid).batchUid(batchUid).configSourceLocaleCode(sourceLocaleCode).userId(workflowParameters.getLoggedUser()).projectUid(workflowParameters.getProjectUid()).pseudo(workflowParameters.isPseudo()).autoAuthorize(workflowParameters.shouldAuthorizeJob()).localeWorkflows(workflowParameters.getLocaleWorkflows()).build();
                folderPath = this.translationProjectManager.createProjectFolder(projectManagerResourceResolver, options);
            }
            finally {
                if (projectManagerResourceResolver != null && projectManagerResourceResolver.isLive()) {
                    projectManagerResourceResolver.close();
                }
            }
            String projectTitle = StringUtils.isNotEmpty((CharSequence)folderPath) && folderPath.contains("/") ? folderPath.substring(folderPath.lastIndexOf("/") + 1) : JcrUtil.createValidName((String)title);
            ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
            WcmWorkflows.Parameters parameters = new WcmWorkflows.Parameters();
            parameters.setTitle(projectTitle);
            parameters.setFolderPath(folderPath);
            parameters.setSourcePageTitle(payloadTitle);
            this.putCustomWorkflowParams(parameters, resourceResolver, workItem);
            if (parameters.getLanguageCopies().isEmpty()) {
                LOGGER.error("There are no language copies available for translation");
                throw new WorkflowException("There are no language copies available for translation");
            }
            this.updateLanguageCopy(workflowSession, parameters);
            workItem.getWorkflowData().getMetaDataMap().put((Object)"batchUid", (Object)batchUid);
            workItem.getWorkflowData().getMetaDataMap().put((Object)"startTime", (Object)System.currentTimeMillis());
            workItem.getWorkflowData().getMetaDataMap().put((Object)"project", (Object)(folderPath + "/" + projectTitle));
        }
        catch (TranslationProjectException | LoginException e) {
            LOGGER.error("Failed to create translation project folder: ", e);
            throw new WorkflowException(FAILED_TO_CREATE_TRANSLATION_PROJECT_FOLDER_MESSAGE, e);
        }
    }

    private <T> T getMandatoryCloudConfig(Resource resource, Class<T> cloudConfigClass, String errorMessage) throws WorkflowException {
        T translationCloudConfig = this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, cloudConfigClass);
        if (translationCloudConfig == null) {
            LOGGER.error("Failed to start translation for page path=\"{}\": no cloud config of type \"{}\" found", (Object)resource.getPath(), (Object)cloudConfigClass.getSimpleName());
            throw new WorkflowException(errorMessage);
        }
        return translationCloudConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createBatch(String jobUid, boolean authorize, SmartlingCloudConfig smartlingCloudConfig) throws WorkflowException {
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(smartlingCloudConfig);){
            String batchUid = platformClient.createBatch(smartlingCloudConfig.getProjectId(), jobUid, authorize);
            LOGGER.info("Created {} batch with batchUid=\"{}\" for jobUid =\"{}\" projectId=\"{}\"", new Object[]{authorize ? "authorized" : "non-authorized", batchUid, jobUid, smartlingCloudConfig.getProjectId()});
            String string = batchUid;
            return string;
        }
        catch (RestApiRuntimeException e) {
            LOGGER.error("Error during creating batch for jobUid =\"{}\" projectId=\"{}\"", new Object[]{jobUid, smartlingCloudConfig.getProjectId(), e});
            throw new WorkflowException(String.format(CREATE_BATCH_EXCEPTION_MESSAGE_FORMAT, jobUid, smartlingCloudConfig.getProjectId()), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("General error on create batch request for jobUid=\"{}\".", (Object)jobUid, (Object)e);
            throw new WorkflowException((Throwable)e);
        }
    }

    protected abstract void updateLanguageCopy(WorkflowSession var1, WcmWorkflows.Parameters var2) throws WorkflowException;

    protected abstract void putCustomWorkflowParams(WcmWorkflows.Parameters var1, ResourceResolver var2, WorkItem var3);
}

