/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow.context;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareGenericProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextAwareWorkflowProcess
extends ContextAwareGenericProcess
implements WorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextAwareWorkflowProcess.class);
    public static final String EXCEPTION_MESSAGE_FORMAT = "Error occurred while submitting content: step=%s failed with message=%s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        try {
            this.injectMDC(workItem, workflowSession);
            if (this.shouldExecute(workItem)) {
                this.executeInternal(workItem, workflowSession, metaDataMap);
            } else {
                LOGGER.warn("workflow={} step={} skipped", (Object)workItem.getId(), this.getClass());
                this.logMetaDataMap(workItem);
            }
        }
        catch (Exception e) {
            String message = String.format(EXCEPTION_MESSAGE_FORMAT, this.getClass(), e.getMessage());
            this.setErrorMessage(workItem, message);
            LOGGER.error(message, (Throwable)e);
        }
        finally {
            this.clearMDC();
            this.markStepAsExecuted(workItem);
        }
    }

    protected abstract void executeInternal(WorkItem var1, WorkflowSession var2, MetaDataMap var3) throws WorkflowException;
}

