/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.google.gson.Gson;
import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServletUtils.class})
public class ServletUtilsImpl
implements ServletUtils {
    public static final String PAGE_PATH_PAYLOAD_PARAMETER = "payload";
    public static final String PAGE_PATH_SIMPLE_PARAMETER = "path";
    private static final String CONFIG_PATH_PARAMETER = "configPath";
    @Reference
    private CloudConfigLocator cloudConfigLocator;

    @Override
    public <T> T getCloudConfigByPagePath(SlingHttpServletRequest request, ResourceResolver resourceResolver, Class<T> cloudConfigClass) {
        if (request.getRequestParameterMap().containsKey((Object)CONFIG_PATH_PARAMETER)) {
            String configPath = request.getParameter(CONFIG_PATH_PARAMETER);
            return this.cloudConfigLocator.getCloudConfig(configPath, cloudConfigClass);
        }
        Resource resource = this.getResourceByRequest(request, resourceResolver);
        return this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, cloudConfigClass);
    }

    @Override
    public <T> T getCloudConfigByPagePath(ResourceResolver resourceResolver, String pagePath, Class<T> cloudConfigClass) {
        Resource resource = this.getResource(resourceResolver, pagePath);
        return this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, cloudConfigClass);
    }

    @Override
    public Resource getResourceByRequest(SlingHttpServletRequest request, ResourceResolver resourceResolver) {
        String pagePath = this.getPayloadPath(request);
        return this.getResource(resourceResolver, pagePath);
    }

    @Override
    public String getPayloadPath(SlingHttpServletRequest request) {
        String pagePath;
        if (request.getRequestParameterMap().containsKey((Object)PAGE_PATH_PAYLOAD_PARAMETER)) {
            pagePath = StringUtils.removeEnd((String)request.getParameter(PAGE_PATH_PAYLOAD_PARAMETER), (String)".html");
        } else if (request.getRequestParameterMap().containsKey((Object)PAGE_PATH_SIMPLE_PARAMETER)) {
            pagePath = StringUtils.removeEnd((String)request.getParameter(PAGE_PATH_SIMPLE_PARAMETER), (String)".html");
        } else {
            throw new IllegalArgumentException("Can't determine page path for loading cloud config");
        }
        return pagePath;
    }

    @Override
    public Resource getResource(ResourceResolver resourceResolver, String path) {
        Resource resource = resourceResolver.resolve(path);
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            throw new IllegalArgumentException(String.format("Resource for path \"%s\" can not be found for path", path));
        }
        return resource;
    }

    @Override
    public void addErrorDetails(HttpServletResponse httpServletResponse, int httpCode, String message) throws IOException {
        HashMap<String, String[]> error = new HashMap<String, String[]>();
        error.put("details", new String[]{message});
        httpServletResponse.setStatus(httpCode);
        this.writeJsonResponse(httpServletResponse, Collections.singletonMap("error", error));
    }

    @Override
    public boolean isCloudConfigOverridden(ResourceResolver resourceResolver, String pagePath) {
        Resource resource = this.getResource(resourceResolver, pagePath);
        return this.cloudConfigLocator.isCloudConfigOverridden(resource);
    }

    private void writeJsonResponse(HttpServletResponse httpServletResponse, Map<String, Object> responseObject) throws IOException {
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json");
        new Gson().toJson(responseObject, (Appendable)httpServletResponse.getWriter());
    }
}

