/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.workflow.WorkflowException;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.TranslationRequest;
import com.smartling.aem.connector.automation.ui.SmartlingJobWorkflowServlet;
import com.smartling.aem.connector.automation.ui.SmartlingJobWorkflowServletValidator;
import com.smartling.aem.connector.automation.ui.SmartlingValidationException;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.paths=/services/smartling/job/workflows/page"})
public class SmartlingJobWorkflowPageServlet
extends SmartlingJobWorkflowServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingJobWorkflowPageServlet.class);
    @Reference
    private SmartlingJobWorkflowServletValidator validator;
    @Reference
    private PageLanguageCopyManager languageCopyManager;

    @Override
    protected void doPostInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        TranslationRequest translationRequest = this.getTranslationRequestBuilder(request);
        String[] paths = translationRequest.getPaths();
        if (paths == null || paths.length == 0) {
            throw new ServletException("No payload provided");
        }
        String pagePath = translationRequest.getPaths()[0];
        SmartlingCloudConfig cloudConfig = this.getSmartlingConfig(resourceResolver, pagePath, translationRequest.getProjectUid());
        String sourceLocaleCode = this.languageCopyManager.getLanguage(resourceResolver, pagePath).getCode();
        translationRequest.setSourceLocaleCode(sourceLocaleCode);
        try {
            this.validator.validateConfig(request, resourceResolver);
            for (String path : paths) {
                if (!translationRequest.isDeep()) continue;
                this.validator.validateChildResourceConfig(path, resourceResolver);
            }
        }
        catch (SmartlingValidationException e) {
            LOGGER.error("Validation failed", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to validate configuration", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        try {
            Map<String, Object> metadata = this.prepareMetadata(request, resourceResolver, translationRequest);
            metadata.put("sourcePathList", translationRequest.getPaths());
            metadata.put("isDeep", translationRequest.isDeep());
            if (translationRequest.isDeep()) {
                metadata.put("excludedPaths", translationRequest.getExcludedPaths());
            }
            metadata.put("configSourceLocaleCode", sourceLocaleCode);
            this.startWorkflow(resourceResolver, pagePath, "/etc/workflow/models/smartling/wcm-translate/jcr:content/model", metadata);
            this.logTranslationRequest(translationRequest, cloudConfig);
        }
        catch (WorkflowException | SmartlingException e) {
            LOGGER.error("Failed to start Job Workflow for page {}:", (Object)pagePath, (Object)e);
            throw new ServletException(e);
        }
    }
}

