/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.callback;

import com.smartling.aem.connector.core.impl.config.CallbackUriProviderConfig;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SmartlingCallbackValidator.class})
public class SmartlingCallbackValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingCallbackValidator.class);
    public static final String SMARTLING_SIGNATURE_HEADER_NAME = "X-Smartling-Signature";
    public static final String FILE_URI_PARAM_NAME = "fileUri";
    public static final String LOCALE_PARAM_NAME = "locale";
    public static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    @Reference
    private CallbackUriProviderConfig callbackConfig;

    public boolean isSignatureMissedOrValid(HttpServletRequest request) {
        String fileUri = request.getParameter(FILE_URI_PARAM_NAME);
        String locale = request.getParameter(LOCALE_PARAM_NAME);
        String secretKey = this.callbackConfig.getCallbackSharedSecret();
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            LOGGER.debug("Callback shared secret is not specified. fileUri=\"{}\" locale=\"{}\". Continue processing the callback.", (Object)fileUri, (Object)locale);
            return true;
        }
        String signature = request.getHeader(SMARTLING_SIGNATURE_HEADER_NAME);
        if (StringUtils.isBlank((CharSequence)signature)) {
            LOGGER.debug("There is no signature in the callback request. fileUri=\"{}\" locale=\"{}\". Continue processing the callback.", (Object)fileUri, (Object)locale);
            return true;
        }
        if ((signature = SmartlingCallbackValidator.base64Decode(signature)) == null) {
            LOGGER.debug("Couldn't decode signature for fileUri=\"{}\" locale=\"{}\".", (Object)fileUri, (Object)locale);
            return false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(secretKeySpec);
            String fullUrl = this.getFullURL(request);
            byte[] signedData = mac.doFinal(fullUrl.getBytes(StandardCharsets.UTF_8));
            String dataHashString = new String(signedData, StandardCharsets.UTF_8);
            boolean result = signature.equals(dataHashString);
            if (!result) {
                LOGGER.error("The request URL=\"{}\" signature is invalid.", (Object)fullUrl);
            }
            return result;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOGGER.error("Couldn't verify signature of callback for fileUri=\"{}\" locale=\"{}\".", new Object[]{fileUri, locale, e});
            return false;
        }
    }

    private String getFullURL(HttpServletRequest request) {
        String callbackURL = this.callbackConfig.getCallbackUrl();
        StringBuilder fullURL = new StringBuilder(callbackURL);
        String queryString = request.getQueryString();
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return fullURL.toString();
        }
        return fullURL.append('?').append(queryString).toString();
    }

    private static String base64Decode(String data) {
        try {
            byte[] decodedSignature = Base64.getDecoder().decode(data);
            return new String(decodedSignature);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

