/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.name;

import com.smartling.aem.connector.automation.ui.validator.name.UniqueJobNameValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UniqueJobNameValidator.class})
public class UniqueJobNameValidatorImpl
implements UniqueJobNameValidator {
    @Reference
    private JobApiClientFactory jobApiClientFactory;

    @Override
    public void validate(String jobName, SmartlingCloudConfig smartlingCloudConfig, String jobUid) throws SmartlingException {
        if (StringUtils.isEmpty((CharSequence)jobName) && StringUtils.isEmpty((CharSequence)jobUid)) {
            throw new SmartlingException("Job name or uid must be provided");
        }
        if (jobName != null && jobName.length() > 170) {
            throw new SmartlingException("Max job name length is 170 chars");
        }
        if (jobName != null && jobUid == null) {
            List<Job> jobs;
            try (JobApiClient jobApiClient = this.jobApiClientFactory.createClient(smartlingCloudConfig);){
                jobs = jobApiClient.listJobsByName(jobName);
            }
            catch (Exception e) {
                throw new SmartlingException("Couldn't list job by name=\"" + jobName + "\".", e);
            }
            if (jobs.stream().anyMatch(job -> jobName.equalsIgnoreCase(job.getName()))) {
                throw new SmartlingException("Unique job name must be provided");
            }
        }
    }
}

