/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.name;

import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.name.UniqueJobNameValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/jobs/name/validator"})
public class UniqueJobNameValidatorServlet
extends SmartlingBaseServlet {
    public static final String NO_CONFIG_FOR_PROJECT = "There is no configuration for project \"%s\"";
    @Reference
    private UniqueJobNameValidator uniqueJobNameValidator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String jobName = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("jobName"), null);
        String jobUid = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("jobUid"), null);
        String projectUid = request.getParameter("projectUid");
        try {
            String path = this.servletUtils.getPayloadPath(request);
            path = StringUtils.substringBefore((String)path, (String)";");
            SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
            if (cloudConfig == null) {
                return;
            }
            cloudConfig = this.cloudConfigResolver.getConfigByPath(cloudConfig, resourceResolver, path, projectUid);
            if (StringUtils.isNotBlank((CharSequence)projectUid) && !StringUtils.equalsIgnoreCase((CharSequence)cloudConfig.getProjectId(), (CharSequence)projectUid)) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, String.format(NO_CONFIG_FOR_PROJECT, projectUid));
                return;
            }
            this.uniqueJobNameValidator.validate(jobName, cloudConfig, jobUid);
        }
        catch (SmartlingException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }
}

