/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.provider;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.smartling.aem.connector.automation.ui.validator.provider.WrongProviderException;
import com.smartling.aem.connector.automation.ui.validator.provider.WrongTranslationMethodException;
import com.smartling.aem.connector.core.SmartlingException;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;

@Component(service={TranslationProviderValidator.class})
public class TranslationProviderValidator {
    public static final String DAM_ROOT_FOLDER = "/content/dam";
    public static final String CONTENT_ROOT_FOLDER = "/content";
    public static final String SMARTLING_PROVIDER_NAME = "smartling";

    public void validate(String path, MachineTranslationCloudConfig machineTranslationCloudConfig) throws SmartlingException {
        this.validateTranslationMethod(path, machineTranslationCloudConfig);
        this.validateTranslationProvider(path, machineTranslationCloudConfig);
    }

    private void validateTranslationMethod(String path, MachineTranslationCloudConfig machineTranslationCloudConfig) throws SmartlingException {
        if (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)DAM_ROOT_FOLDER) ? machineTranslationCloudConfig.getDefaultTranslationProviderWorkflowForAssets() != MachineTranslationCloudConfig.TranslationProviderWorkflow.HUMAN_TRANSLATION : StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)CONTENT_ROOT_FOLDER) && machineTranslationCloudConfig.getDefaultTranslationProviderWorkflowForSites() != MachineTranslationCloudConfig.TranslationProviderWorkflow.HUMAN_TRANSLATION) {
            throw new WrongTranslationMethodException("Smartling supports `Human translation` translation method only. Set proper method in Cloud Configuration");
        }
    }

    public void validateTranslationProvider(String path, MachineTranslationCloudConfig machineTranslationCloudConfig) throws SmartlingException {
        if (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)DAM_ROOT_FOLDER)) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)machineTranslationCloudConfig.getDefaultPostEditProviderForAssets(), (CharSequence)SMARTLING_PROVIDER_NAME)) {
                throw new WrongProviderException("Smartling is not specified as a Translation Provider for Assets. Current provider is " + machineTranslationCloudConfig.getDefaultPostEditProviderForAssets());
            }
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)CONTENT_ROOT_FOLDER) && !StringUtils.equalsIgnoreCase((CharSequence)machineTranslationCloudConfig.getDefaultPostEditProviderForSites(), (CharSequence)SMARTLING_PROVIDER_NAME)) {
            throw new WrongProviderException("Smartling is not specified as a Translation Provider for Sites. Current provider is " + machineTranslationCloudConfig.getDefaultPostEditProviderForSites());
        }
    }
}

