/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core;

import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={SmartlingCredentialsConfiguration.class})
@Designate(ocd=Config.class)
public class SmartlingCredentialsConfiguration {
    private String projectId;
    private String userIdentifier;
    private String tokenSecret;

    @Activate
    protected void activate(Config config) throws Exception {
        this.projectId = config.smartling_credentials_project_id();
        this.userIdentifier = config.smartling_credentials_user_identifier();
        this.tokenSecret = config.smartling_credentials_token_secret();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public boolean isSpecified() {
        return StringUtils.isNotBlank((CharSequence)this.projectId) && StringUtils.isNotBlank((CharSequence)this.userIdentifier) && StringUtils.isNotBlank((CharSequence)this.tokenSecret);
    }

    @ObjectClassDefinition(name="Smartling - Credentials (Touch)", description="Allows to set up Smartling credentials for the whole environment.")
    public static @interface Config {
        @AttributeDefinition(name="Project ID", description="Specify Smartling project Id.")
        public String smartling_credentials_project_id() default "";

        @AttributeDefinition(name="User Identifier", description="Specify Smartling user identifier.")
        public String smartling_credentials_user_identifier() default "";

        @AttributeDefinition(name="Token Secret", description="Specify Smartling token secret.", type=AttributeType.PASSWORD)
        public String smartling_credentials_token_secret() default "";
    }
}

