/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl;

import com.adobe.granite.comments.Comment;
import com.adobe.granite.comments.CommentCollection;
import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationObject;
import com.adobe.granite.translation.api.TranslationResult;
import com.adobe.granite.translation.api.TranslationState;
import com.adobe.granite.translation.core.common.AbstractTranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSmartlingHumanTranslationService
extends AbstractTranslationService {
    private static final String TRANSLATION_MEMORY_NOT_SUPPORTED_MESSAGE = "Direct interaction with Translation Memory is not supported";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    AbstractSmartlingHumanTranslationService(Map<String, String> languageMapping, String name, String label, TranslationConfig config) {
        super(languageMapping, Collections.emptyMap(), name, label, null, "/libs/settings/cloudconfigs/translation/smartling-translation", TranslationConstants.TranslationMethod.HUMAN_TRANSLATION, config);
    }

    Map<String, String> getAvailableLanguages() {
        return this.availableLanguageMap;
    }

    public TranslationResult translateString(String sourceString, String sourceLanguage, String targetLanguage, TranslationConstants.ContentType contentType, String contentCategory) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#translateString({}, {}, {}, {}, {})", new Object[]{sourceString, sourceLanguage, targetLanguage, contentType, contentCategory});
        throw new TranslationException("Synchronous translation is not supported", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationResult[] translateArray(String[] strings, String sourceLanguage, String targetLanguage, TranslationConstants.ContentType contentType, String contentCategory) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#translateArray([{}],...)", (Object)Arrays.toString(strings));
        throw new TranslationException("Synchronous translation is not supported", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public CommentCollection<Comment> getTranslationJobCommentCollection(String jobId) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#getTranslationJobCommentCollection({})", (Object)jobId);
        throw new TranslationException("Smartling does not support retrieving comments", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public void addTranslationJobComment(String jobId, Comment comment) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#addTranslationJobComment({},...)", (Object)jobId);
        throw new TranslationException("Smartling does not sending comments", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public CommentCollection<Comment> getTranslationObjectCommentCollection(String jobId, TranslationObject translationObject) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#getTranslationObjectCommentCollection({},...)", (Object)jobId);
        throw new TranslationException("Smartling does not support retrieving comments", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public void addTranslationObjectComment(String jobId, TranslationObject translationObject, Comment comment) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#addTranslationObjectComment({},...)", (Object)jobId);
        throw new TranslationException("Smartling does not support sending comments", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationConstants.TranslationStatus[] updateTranslationObjectsState(String jobId, TranslationObject[] translationObjects, TranslationState[] translationStates) throws TranslationException {
        throw new TranslationException("Smartling does not support bulk operations", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationConstants.TranslationStatus[] getTranslationObjectsStatus(String jobId, TranslationObject[] translationObjects) throws TranslationException {
        throw new TranslationException("Smartling does not support bulk operations", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public TranslationResult[] getAllStoredTranslations(String sourceString, String sourceLanguage, String targetLanguage, TranslationConstants.ContentType contentType, String contentCategory, String userId, int maxTranslations) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#getAllStoredTranslations(...)");
        throw new TranslationException(TRANSLATION_MEMORY_NOT_SUPPORTED_MESSAGE, TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public void storeTranslation(String originalText, String sourceLanguage, String targetLanguage, String updatedTranslation, TranslationConstants.ContentType contentType, String contentCategory, String userId, int rating, String path) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#storeTranslation(...)");
        throw new TranslationException(TRANSLATION_MEMORY_NOT_SUPPORTED_MESSAGE, TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    public void storeTranslation(String[] originalText, String sourceLanguage, String targetLanguage, String[] updatedTranslation, TranslationConstants.ContentType contentType, String contentCategory, String userId, int rating, String path) throws TranslationException {
        this.logger.trace("In SmartlingTranslationService#storeTranslation(...)");
        throw new TranslationException(TRANSLATION_MEMORY_NOT_SUPPORTED_MESSAGE, TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }
}

