/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationMetadata;
import com.adobe.granite.translation.api.TranslationObject;
import com.adobe.granite.translation.api.TranslationScope;
import com.adobe.granite.translation.api.TranslationService;
import com.adobe.granite.translation.api.TranslationState;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingException;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingTranslationService;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationDetailsManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.AbstractSmartlingHumanTranslationService;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.TranslationObjectToResourceAdapter;
import com.smartling.aem.connector.core.impl.integration.NoTranslatableContentException;
import com.smartling.aem.connector.core.impl.integration.NotSupportedFormatException;
import com.smartling.aem.connector.core.impl.integration.platform.SmartlingSupport;
import com.smartling.api.v2.client.exception.client.NotFoundErrorException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmartlingTranslationService
extends AbstractSmartlingHumanTranslationService
implements TranslationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingTranslationService.class);
    public static final String FAILED_TO_GET_OBJECT_LOG_MESSAGE_FORMAT = "Failed to get object: \"{}\"";
    private final SmartlingCloudConfig cloudConfig;
    private final SmartlingFacade facade;
    private PropertyMappingTranslationService propertyMappingTranslationService;
    private TranslationDetailsManager translationDetailsManager;

    SmartlingTranslationService(@Nonnull SmartlingCloudConfig cloudConfig, String name, String label, TranslationConfig config, SmartlingFacade facade, PropertyMappingTranslationService propertyMappingTranslationService, TranslationDetailsManager translationDetailsManager) {
        super(cloudConfig.getLanguageMapping(), name, label, config);
        this.cloudConfig = cloudConfig;
        this.facade = facade;
        this.propertyMappingTranslationService = propertyMappingTranslationService;
        this.translationDetailsManager = translationDetailsManager;
    }

    public String createTranslationJob(String name, String description, String sourceLanguage, String targetLanguage, Date dueDate, TranslationState state, TranslationMetadata jobMetadata) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#createTranslationJob({}, .., {}, {}, ..)", new Object[]{name, sourceLanguage, targetLanguage});
        String smartlingSourceLanguageCode = this.mapToSmartlingLocaleCode(sourceLanguage);
        String smartlingTargetLanguageCode = this.mapToSmartlingLocaleCode(targetLanguage);
        try {
            return this.facade.createTranslationJob(smartlingSourceLanguageCode, smartlingTargetLanguageCode);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to create translation job jobName=\"{}\" sourceLanguage=\"{}\" targetLanguage=\"{}\":", new Object[]{name, sourceLanguage, targetLanguage, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public void updateTranslationJobMetadata(String jobId, TranslationMetadata jobMetadata, TranslationConstants.TranslationMethod translationMethod) {
        LOGGER.trace("In SmartlingTranslationService#updateTranslationJobMetadata({},...)", (Object)jobId);
        LOGGER.warn("Could not update translation Job metadata: feature is not implemented.");
    }

    public String uploadTranslationObject(String jobId, TranslationObject translationObject) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#uploadTranslationObject({}, \"{}\"[{}])", new Object[]{jobId, translationObject.getTitle(), translationObject.getTranslationObjectSourcePath()});
        try {
            SmartlingFacade.Resource resource;
            String translationObjectFileType = this.translationDetailsManager.getTranslationObjectDetails(jobId, translationObject.getTranslationObjectSourcePath()).getTranslationObjectFileType();
            if ("ASSET".equals(translationObjectFileType)) {
                String mimeType = translationObject.getMimeType();
                if (StringUtils.isNotBlank((CharSequence)mimeType) && SmartlingSupport.FILE_TYPE_BY_MIME.containsKey(mimeType)) {
                    LOGGER.trace("Asset mime=\"{}\" is going to be uploaded, objectTitle=\"{}\" objectPath=\"{}\" jobId=\"{}\"", new Object[]{mimeType, translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId});
                    TranslationObjectToResourceAdapter resource2 = new TranslationObjectToResourceAdapter(translationObject, translationObject.getTranslationObjectInputStream(), SmartlingFacade.Type.ASSET, translationObjectFileType);
                    return this.facade.uploadFile(this.cloudConfig, jobId, resource2);
                }
                LOGGER.warn("Asset mime=\"{}\" is not supported, objectTitle=\"{}\" objectPath=\"{}\" jobId=\"{}\"", new Object[]{mimeType, translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId});
            }
            if (SmartlingTranslationService.isPathForDita(translationObject.getTranslationObjectSourcePath())) {
                LOGGER.trace("DITA asset is going to be uploaded, objectTitle=\"{}\" objectPath=\"{}\" jobId=\"{}\"", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId});
                resource = new TranslationObjectToResourceAdapter(translationObject, translationObject.getTranslationObjectInputStream(), SmartlingFacade.Type.DITA, translationObjectFileType);
            } else {
                resource = this.propertyMappingTranslationService.getTranslationResource(translationObject, translationObjectFileType);
            }
            return this.facade.uploadFile(this.cloudConfig, jobId, resource);
        }
        catch (NotSupportedFormatException e) {
            LOGGER.info("Skipped file objectTitle=\"{}\" objectPath=\"{}\" jobId=\"{}\": due message=\"{}\"", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e.getMessage()});
            return null;
        }
        catch (NoTranslatableContentException e) {
            LOGGER.info("Failed to upload file objectTitle=\"{}\" objectPath=\"{}\" jobId=\"{}\", no source strings found. \"{}\"", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e.getMessage()});
            return null;
        }
        catch (PropertyMappingException e) {
            LOGGER.error("Failed to apply Smartling property mappings for file objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\"", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException("Failed to apply Smartling property mappings", (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to upload translation object objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't upload translation object objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public TranslationScope getFinalScope(String jobId) {
        LOGGER.trace("In SmartlingTranslationService#getFinalScope({})", (Object)jobId);
        LOGGER.warn("Scoping is not supported by Smartling. Empty result will be returned.");
        return new DummyTranslationScope();
    }

    public TranslationConstants.TranslationStatus updateTranslationJobState(String jobId, TranslationState state) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#updateTranslationJobState({}, {})", (Object)jobId, (Object)state.getStatus());
        if (state.getStatus() == TranslationConstants.TranslationStatus.CANCEL) {
            try {
                this.facade.deleteTranslationJob(this.cloudConfig, jobId);
            }
            catch (SmartlingException e) {
                LOGGER.error("Failed to delete translation job jobId=\"{}\":", (Object)jobId, (Object)e);
                throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't delete translation job jobId=\"{}\":", (Object)jobId, (Object)e);
                throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
        } else if (state.getStatus() == TranslationConstants.TranslationStatus.SCOPE_REQUESTED) {
            throw new TranslationException("Smartling does not support scoping", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
        }
        return state.getStatus();
    }

    public TranslationConstants.TranslationStatus getTranslationJobStatus(String jobId) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#getTranslationJobStatus({})", (Object)jobId);
        if (StringUtils.isEmpty((CharSequence)jobId)) {
            return TranslationConstants.TranslationStatus.DRAFT;
        }
        try {
            SmartlingFacade.Status jobStatus = this.facade.getJobStatus(this.cloudConfig, jobId);
            return SmartlingTranslationService.toTranslationStatus(jobStatus);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to get translation job status jobId=\"{}\":", (Object)jobId, (Object)e);
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't get translation job status jobId=\"{}\":", (Object)jobId, (Object)e);
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public InputStream getTranslatedObject(String jobId, TranslationObject translationObject) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#getTranslatedObject(..., {})", (Object)translationObject.getId());
        try {
            InputStream stream = this.facade.getTranslatedFile(this.cloudConfig, jobId, translationObject.getId());
            String translationObjectFileType = this.translationDetailsManager.getTranslationObjectDetails(jobId, translationObject.getTranslationObjectSourcePath()).getTranslationObjectFileType();
            if ("ASSET".equalsIgnoreCase(translationObjectFileType)) {
                String mimeType = translationObject.getMimeType();
                if (StringUtils.isNotBlank((CharSequence)mimeType) && SmartlingSupport.FILE_TYPE_BY_MIME.containsKey(mimeType)) {
                    return stream;
                }
                LOGGER.error("Couldn't download translation object with unknown MIME type mime=\"{}\" objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{mimeType, translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId});
                throw new TranslationException("Couldn't download translation object with unknown MIME type", TranslationException.ErrorCode.NOT_SUPPORTED_FORMAT);
            }
            if (SmartlingTranslationService.isPathForDita(translationObject.getTranslationObjectSourcePath())) {
                return stream;
            }
            return this.propertyMappingTranslationService.removeCustomizations(stream);
        }
        catch (PropertyMappingException e) {
            LOGGER.error("Failed to remove property mappings customizations objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException("Failed to remove property mappings customizations", (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        catch (SmartlingException e) {
            if (!SmartlingTranslationService.logNoFoundException(e)) {
                LOGGER.error("Failed to get translated content objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            }
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't get translated content objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public TranslationConstants.TranslationStatus updateTranslationObjectState(String jobId, TranslationObject translationObject, TranslationState translationState) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#updateTranslationObjectState(..., {}, {})", (Object)translationObject.getId(), (Object)translationState.getStatus());
        if (translationState.getStatus() == TranslationConstants.TranslationStatus.CANCEL) {
            if (SmartlingTranslationService.wasUploaded(translationObject)) {
                try {
                    this.facade.deleteFile(this.cloudConfig, jobId, translationObject.getId());
                }
                catch (SmartlingException e) {
                    if (!SmartlingTranslationService.logNoFoundException(e)) {
                        LOGGER.error("Failed to delete file objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
                    }
                    throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't delete file objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
                    throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
                }
            } else {
                LOGGER.debug("Translation Object objectPath=\"{}\", jobId=\"{}\" has never been sent for translation. No need to cancel it.", (Object)translationObject.getTranslationObjectSourcePath(), (Object)jobId);
            }
        }
        return translationState.getStatus();
    }

    public TranslationConstants.TranslationStatus getTranslationObjectStatus(String jobId, TranslationObject translationObject) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#getTranslationObjectStatus(..., {})", (Object)translationObject.getId());
        if (SmartlingTranslationService.isInTerminalState(translationObject)) {
            TranslationConstants.TranslationStatus currentStatus = translationObject.getTranslationJobMetadata().getTranslationState().getStatus();
            LOGGER.info("Translation object objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\" is already in {} state. Nothing to do.", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, currentStatus});
            return currentStatus;
        }
        if (SmartlingTranslationService.wasUploaded(translationObject)) {
            try {
                SmartlingFacade.Status status = this.facade.getObjectStatus(this.cloudConfig, jobId, translationObject.getId());
                return SmartlingTranslationService.toTranslationStatus(status);
            }
            catch (SmartlingException e) {
                if (!SmartlingTranslationService.logNoFoundException(e)) {
                    LOGGER.error("Failed to get translation object status objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
                }
                throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't get translation object status objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\":", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId, e});
                throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
            }
        }
        LOGGER.info("Translation object objectTitle=\"{}\" objectPath=\"{}\", jobId=\"{}\": has never been sent for translation. Marking it as Ready for Review.", new Object[]{translationObject.getTitle(), translationObject.getTranslationObjectSourcePath(), jobId});
        return TranslationConstants.TranslationStatus.READY_FOR_REVIEW;
    }

    private static boolean isInTerminalState(TranslationObject translationObject) {
        TranslationConstants.TranslationStatus status = translationObject.getTranslationJobMetadata().getTranslationState().getStatus();
        return status == TranslationConstants.TranslationStatus.CANCEL || status == TranslationConstants.TranslationStatus.APPROVED || status == TranslationConstants.TranslationStatus.REJECTED;
    }

    private static boolean wasUploaded(TranslationObject translationObject) {
        return translationObject.getId() != null;
    }

    public Map<String, String> supportedLanguages() {
        LOGGER.trace("In SmartlingTranslationService#supportedLanguages()");
        return Collections.unmodifiableMap(this.getAvailableLanguages());
    }

    public boolean isDirectionSupported(String sourceLanguage, String targetLanguage) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#isDirectionSupported({}, {})", (Object)sourceLanguage, (Object)targetLanguage);
        try {
            return this.cloudConfig.isDirectionSupported(sourceLanguage, targetLanguage);
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to check if direction of translation supported sourceLanguage=\"{}\" targetLanguage=\"{}\":", new Object[]{sourceLanguage, targetLanguage, e});
            throw new TranslationException(e.getMessage(), (Throwable)e, TranslationException.ErrorCode.GENERAL_EXCEPTION);
        }
    }

    public String detectLanguage(String detectSource, TranslationConstants.ContentType contentType) throws TranslationException {
        LOGGER.trace("In SmartlingTranslationService#detectLanguage({}, {})", (Object)detectSource, (Object)contentType);
        throw new TranslationException("Smartling does not support language detection", TranslationException.ErrorCode.SERVICE_NOT_IMPLEMENTED);
    }

    private String mapToSmartlingLocaleCode(String localeCode) throws TranslationException {
        String smartlingSourceLanguageCode = this.getAvailableLanguages().get(localeCode);
        if (smartlingSourceLanguageCode == null) {
            throw new TranslationException("Locale " + localeCode + " is not supported", TranslationException.ErrorCode.NOT_SUPPORTED_LANG_DIRECTION);
        }
        return smartlingSourceLanguageCode;
    }

    private static TranslationConstants.TranslationStatus toTranslationStatus(SmartlingFacade.Status status) {
        if (status == SmartlingFacade.Status.NA) {
            return TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION;
        }
        if (status == SmartlingFacade.Status.IN_PROGRESS) {
            return TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS;
        }
        return TranslationConstants.TranslationStatus.TRANSLATED;
    }

    private static boolean logNoFoundException(SmartlingException caught) {
        if (caught.getCause() != null && caught.getCause() instanceof NotFoundErrorException) {
            NotFoundErrorException apiException = (NotFoundErrorException)caught.getCause();
            LOGGER.error(FAILED_TO_GET_OBJECT_LOG_MESSAGE_FORMAT, (Object)apiException.getMessage());
            return true;
        }
        return false;
    }

    private static boolean isPathForDita(String path) {
        return StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)".dita") || StringUtils.endsWithIgnoreCase((CharSequence)path, (CharSequence)".ditamap");
    }

    private static class DummyTranslationScope
    implements TranslationScope {
        private DummyTranslationScope() {
        }

        public int getWordCount() {
            return 0;
        }

        public int getImageCount() {
            return 0;
        }

        public int getVideoCount() {
            return 0;
        }

        public Map<String, String> getFinalScope() {
            return Collections.emptyMap();
        }
    }
}

