/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import com.adobe.granite.crypto.CryptoSupport;
import com.smartling.aem.connector.automation.ui.SmartlingDialogConfiguration;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingCredentialsConfiguration;
import com.smartling.aem.connector.core.impl.config.JcrSmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.config.OsgiSmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.integration.platform.ProjectApiClientFactory;
import java.util.Collections;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AdapterFactory.class}, property={"adapters=com.smartling.aem.connector.core.SmartlingCloudConfig", "adaptables=org.apache.sling.api.resource.Resource"})
public class SmartlingCloudConfigAdapterFactory
implements AdapterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingCloudConfigAdapterFactory.class);
    public static final String CONFIG_NAME = "smartling-translation";
    private static final String TRANSLATION_OBJECT_QUERY = "SELECT * FROM [cq:PageContent] AS s WHERE ISDESCENDANTNODE('%s') and s.'cq:cloudservicename'='%s'";
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private ProjectApiClientFactory projectApiClientFactory;
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private SmartlingDialogConfiguration smartlingDialogConfiguration;
    @Reference
    private SmartlingCredentialsConfiguration osgiCredentialsConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> A getAdapter(Object adaptable, Class<A> adapterType) {
        if (adapterType != SmartlingCloudConfig.class) {
            return null;
        }
        if (adaptable == null) {
            LOGGER.error("Couldn't adapt null config resource");
            return null;
        }
        if (!(adaptable instanceof Resource)) {
            LOGGER.error("Couldn't adapt non-resource config");
            return null;
        }
        Resource configResource = (Resource)adaptable;
        ResourceResolver resourceResolver = null;
        SmartlingCloudConfig config = null;
        String configResourcePath = configResource.getPath();
        LOGGER.trace("Looking for config by path=\"{}\"", (Object)configResourcePath);
        try {
            String configPath;
            resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
            configResource = resourceResolver.getResource(configResourcePath);
            if (configResource == null) {
                LOGGER.error("Couldn't locate config resource path=\"{}\". Check connector permissions.", (Object)configResourcePath);
                A a = null;
                return a;
            }
            Resource configPageContentResource = configResource.getChild("jcr:content");
            if (configPageContentResource != null && CONFIG_NAME.equals(SmartlingCloudConfigAdapterFactory.getConfigName(configPageContentResource))) {
                LOGGER.trace("Adapting path=\"{}\" to SmartlingCloudConfig...", (Object)configPageContentResource.getPath());
                config = this.createConfig(configPageContentResource);
            }
            if (config == null && (configPath = this.findSmartlingConfigurationContentPath(configResource)) != null && (configPageContentResource = resourceResolver.getResource(configPath)) != null) {
                config = this.createConfig(configPageContentResource);
            }
        }
        catch (LoginException e) {
            LOGGER.error("Failed to login into repository for adapting config path={}", (Object)configResourcePath, (Object)e);
            A a = null;
            return a;
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return adapterType.cast(config);
    }

    private static Object getConfigName(Resource configPageContentResource) {
        return configPageContentResource.getValueMap().get((Object)"cq:cloudservicename");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findSmartlingConfigurationContentPath(Resource resource) {
        String path = resource.getPath();
        if (!StringUtils.contains((CharSequence)path, (CharSequence)"/translation/")) {
            if (this.smartlingDialogConfiguration.isLegacyConfigValidationEnabled()) return null;
            LOGGER.warn("Couldn't find Smartling configuration by configPath=\"{}\"", (Object)path);
            return null;
        }
        path = StringUtils.substringBefore((String)path, (String)"/translation/") + "/translation";
        LOGGER.trace("Trying to find configuration under path=\"{}\"", (Object)path);
        try {
            Session session = this.repository.loginService(null, null);
            String queryString = String.format(TRANSLATION_OBJECT_QUERY, path, CONFIG_NAME);
            try {
                Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
                NodeIterator nodes = query.execute().getNodes();
                if (!nodes.hasNext()) return null;
                String string = nodes.nextNode().getPath();
                return string;
            }
            catch (RepositoryException e) {
                LOGGER.error("Couldn't to get Smartling configuration for path='{}'. Failed to run query '{}'", new Object[]{resource.getPath(), queryString, e});
                return null;
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            LOGGER.error("Couldn't get Smartling configuration for path='{}'. Initialization of JCR Session failed", (Object)resource.getPath(), (Object)e);
        }
        return null;
    }

    private SmartlingCloudConfig createConfig(Resource configPageContentResource) {
        if (this.osgiCredentialsConfig.isSpecified()) {
            return new OsgiSmartlingCloudConfig(this.osgiCredentialsConfig, this.projectApiClientFactory, configPageContentResource.getResourceResolver());
        }
        return new JcrSmartlingCloudConfig(configPageContentResource, this.cryptoSupport, this.projectApiClientFactory);
    }

    public void setResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    public void setSmartlingDialogConfiguration(SmartlingDialogConfiguration smartlingDialogConfiguration) {
        this.smartlingDialogConfiguration = smartlingDialogConfiguration;
    }

    public void setOsgiCredentialsConfig(SmartlingCredentialsConfiguration osgiCredentialsConfig) {
        this.osgiCredentialsConfig = osgiCredentialsConfig;
    }

    public void setCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    public void setProjectApiClientFactory(ProjectApiClientFactory projectApiClientFactory) {
        this.projectApiClientFactory = projectApiClientFactory;
    }

    public void setRepository(SlingRepository repository) {
        this.repository = repository;
    }
}

