/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.smartling.aem.connector.core.NetworkSettings;
import com.smartling.aem.connector.core.SmartlingCredentials;
import com.smartling.aem.connector.core.impl.config.ProjectMetadata;
import com.smartling.api.v2.authentication.AuthenticationApiFactory;
import com.smartling.api.v2.client.AbstractApiFactory;
import com.smartling.api.v2.client.ClientConfiguration;
import com.smartling.api.v2.client.ClientFactory;
import com.smartling.api.v2.client.DefaultClientConfiguration;
import com.smartling.api.v2.client.HttpClientConfiguration;
import com.smartling.api.v2.client.auth.Authenticator;
import com.smartling.api.v2.client.auth.AuthorizationRequestFilter;
import com.smartling.api.v2.client.auth.BearerAuthSecretFilter;
import com.smartling.api.v2.client.useragent.LibNameVersionHolder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ApiInstanceBuilder.class}, immediate=true)
@Designate(ocd=Config.class)
public class ApiInstanceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiInstanceBuilder.class);
    private static final long CACHE_TTL = 7L;
    public static final String DEFAULT_API_HOST = "https://api.smartling.com";
    private static final int SOCKET_TIMEOUT_MIN = 10000;
    private static final int SOCKET_TIMEOUT_MAX = 60000;
    private static final int SOCKET_TIMEOUT_DEFAULT = 40000;
    private String apiHost;
    private boolean useAuthCache;
    @Reference
    private NetworkSettings networkSettings;
    @Reference
    private ProjectMetadata projectMetadata;
    private ClientFactory clientFactory;
    private ClientConfiguration clientConfiguration;
    private Cache<String, Authenticator> authenticatorCache;
    private int socketTimeout;

    @Activate
    protected void activate(Config config) {
        this.apiHost = (String)StringUtils.defaultIfEmpty((CharSequence)config.api_host(), (CharSequence)DEFAULT_API_HOST);
        this.useAuthCache = config.api_cache_auth_enabled();
        this.socketTimeout = 40000;
        try {
            this.socketTimeout = config.api_socket_timeout();
            this.socketTimeout = Math.max(this.socketTimeout, 10000);
            this.socketTimeout = Math.min(this.socketTimeout, 60000);
        }
        catch (Exception e) {
            LOGGER.error("Error while setting socket timeout. Default value '{}' was applied", (Object)40000, (Object)e);
        }
        this.authenticatorCache = Caffeine.newBuilder().expireAfterWrite(7L, TimeUnit.HOURS).build();
        this.clientFactory = new ClientFactory();
        this.clientConfiguration = this.getClientConfiguration();
    }

    public ClientFactory getClientFactory() {
        return this.clientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T buildClient(AbstractApiFactory<T> apiFactory, SmartlingCredentials config) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(apiFactory.getClass().getClassLoader());
            T t = this.buildApi(apiFactory, config.getUserIdentifier(), config.getTokenSecret());
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    private <T> T buildApi(AbstractApiFactory<T> apiFactory, String userIdentifier, String userSecret) {
        Objects.requireNonNull(userIdentifier, "userIdentifier must be defined");
        Objects.requireNonNull(userSecret, "userSecret must be defined");
        Authenticator authenticator = this.getAuthenticator(userIdentifier, userSecret);
        BearerAuthSecretFilter bearerAuthSecretFilter = new BearerAuthSecretFilter(authenticator);
        return (T)apiFactory.buildApi((AuthorizationRequestFilter)bearerAuthSecretFilter, this.clientConfiguration);
    }

    private ClientConfiguration getClientConfiguration() {
        DefaultClientConfiguration.DefaultClientConfigurationBuilder defaultClientConfigurationBuilder = DefaultClientConfiguration.builder();
        HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration();
        httpClientConfiguration.setSocketTimeout(this.socketTimeout);
        if (this.networkSettings.isProxyEnabled()) {
            httpClientConfiguration.setProxyHost(this.networkSettings.getProxyHost());
            httpClientConfiguration.setProxyPort(this.networkSettings.getProxyPort().intValue());
            if (this.networkSettings.requireProxyAuthentication()) {
                httpClientConfiguration.setProxyUser(this.networkSettings.getProxyUser());
                httpClientConfiguration.setProxyPassword(this.networkSettings.getProxyPassword());
            }
        }
        defaultClientConfigurationBuilder.httpClientConfiguration(httpClientConfiguration);
        LibNameVersionHolder libNameVersionHolder = new LibNameVersionHolder(this.projectMetadata.getName(), this.projectMetadata.getVersion());
        defaultClientConfigurationBuilder.libNameVersionHolder(libNameVersionHolder);
        try {
            defaultClientConfigurationBuilder.baseUrl(new URL(this.apiHost));
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Couldn't set apiHost=\"{}\" for client API configuration", (Object)this.apiHost, (Object)ex);
        }
        return defaultClientConfigurationBuilder.build();
    }

    private Authenticator getAuthenticator(String userIdentifier, String userSecret) {
        if (!this.useAuthCache) {
            return this.createAuthenticator(userIdentifier, userSecret);
        }
        String key = this.createCacheKey(userIdentifier, userSecret);
        return (Authenticator)this.authenticatorCache.get((Object)key, String2 -> this.createAuthenticator(userIdentifier, userSecret));
    }

    private Authenticator createAuthenticator(String userIdentifier, String userSecret) {
        return new Authenticator(userIdentifier, userSecret, new AuthenticationApiFactory(this.clientFactory).buildApi(this.clientConfiguration));
    }

    private String createCacheKey(String userIdentifier, String userSecret) {
        return userIdentifier.concat(userSecret);
    }

    @ObjectClassDefinition(name="Smartling - API SDK Configuration (Touch)", description="Allows to set custom API endpoint and manage API Authentication cache.")
    public static @interface Config {
        @AttributeDefinition(name="API Host", description="If empty then default 'https://api.smartling.com' will be used.")
        public String api_host() default "https://api.smartling.com";

        @AttributeDefinition(name="Enable API Authentication Cache", description="Enables Auth cache over all API clients")
        public boolean api_cache_auth_enabled() default true;

        @AttributeDefinition(name="Socket timeout", description="Socket timout for requests sent to Smartling side in ms.  Min 10000ms, Max 60000ms, 40000ms by default.")
        public int api_socket_timeout() default 40000;
    }
}

