/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JsonAutoDetectStringProcessor.class}, immediate=true)
@Designate(ocd=Config.class)
public class JsonAutoDetectStringProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonAutoDetectStringProcessor.class);
    private Map<String, String> autoDetectStringFormatJsonDirectives = Collections.emptyMap();
    private String translatePathsDirectiveValue = "";
    private boolean enabledUnescaping;

    @Activate
    protected void activate(Config config) {
        this.enabledUnescaping = config.enabled();
        if (this.enabledUnescaping) {
            LOGGER.info("Unescaping html in json properties is enabled");
            String[] fields = config.translatableFields();
            Set fieldsWithJson = Arrays.stream(fields).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            this.autoDetectStringFormatJsonDirectives = Collections.singletonMap("smartling.auto_detect_string_format", "json");
            this.translatePathsDirectiveValue = String.join((CharSequence)", ", fieldsWithJson);
        }
    }

    public Map<String, String> getAutoDetectStringJsonFormatDirectives() {
        return this.autoDetectStringFormatJsonDirectives;
    }

    public String getTranslatePathsDirectiveValue() {
        return this.translatePathsDirectiveValue;
    }

    @ObjectClassDefinition(name="Smartling - Parse JSON strings (Touch)", description="Ingest JSON as translatable content")
    public static @interface Config {
        @AttributeDefinition(name="Enables JSON auto detect", description="This will add additional smartling directives in order to enable JSON auto detect in AEM page properties")
        public boolean enabled() default false;

        @AttributeDefinition(name="JSON translatable fields", description="Only these JSON fields will be ingested as content")
        public String[] translatableFields() default {};
    }
}

