/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.processor;

import com.smartling.aem.connector.core.impl.integration.platform.processor.PostDownloadProcessor;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessorService {
    private final List<PostDownloadProcessor> processors = new LinkedList<PostDownloadProcessor>();

    public ProcessorService(PostDownloadProcessor ... processors) {
        Collections.addAll(this.processors, processors);
    }

    public byte[] process(byte[] content) {
        List supportedProcessors = this.processors.stream().filter(input -> input.supports(content)).collect(Collectors.toList());
        byte[] processedContent = content;
        for (PostDownloadProcessor processor : supportedProcessors) {
            processedContent = processor.process(processedContent);
        }
        return processedContent;
    }
}

