/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.storage;

import com.adobe.cq.wcm.launches.utils.LaunchUtils;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.TranslationProject;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.core.FileUriResolver;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FileUriResolver.class})
public class FileUriResolverImpl
implements FileUriResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUriResolverImpl.class);
    public static final String CONTENT_ROOT_FOLDER = "/content";
    public static final String DAM_ROOT_FOLDER = "/content/dam";
    public static final String LAUNCH_ROOT_FOLDER = "/content/launches";
    public static final String FORM_ROOT_ASSET_PATH = "/content/dam/formsanddocuments";
    public static final String PROJECTS_ROOT_FOLDER = "/content/projects";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private TranslationProjectManager translationProjectManager;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPathByFileUri(String fileUri, boolean fromSource) throws SmartlingException {
        if (StringUtils.containsNone((CharSequence)fileUri, (String)":")) {
            LOGGER.error("Couldn't find job-path separator in fileUri=\"{}\"", (Object)fileUri);
            return fileUri;
        }
        String translationJobId = StringUtils.substringBefore((String)fileUri, (String)":");
        if (StringUtils.isBlank((CharSequence)translationJobId) || StringUtils.equalsIgnoreCase((CharSequence)translationJobId, (CharSequence)"http") || StringUtils.equalsIgnoreCase((CharSequence)translationJobId, (CharSequence)"https")) {
            LOGGER.info("Couldn't find translation job id in fileUri=\"{}\"", (Object)fileUri);
            return fileUri;
        }
        String objectPath = StringUtils.substringAfter((String)fileUri, (String)":");
        if (StringUtils.startsWithIgnoreCase((CharSequence)objectPath, (CharSequence)FORM_ROOT_ASSET_PATH)) {
            objectPath = StringUtils.substringBeforeLast((String)objectPath, (String)"jcr:content") + "jcr:content";
            return objectPath;
        }
        if (!fromSource) {
            LOGGER.info("Context for fileUri=\"{}\" shouldn't be taken from a source", (Object)fileUri);
            return objectPath;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)objectPath, (CharSequence)CONTENT_ROOT_FOLDER)) {
            LOGGER.info("File with fileUri=\"{}\" doesn't seem to belong /content folder.", (Object)fileUri);
            return objectPath;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)objectPath, (CharSequence)PROJECTS_ROOT_FOLDER)) {
            LOGGER.info("Found projects folder at {} ", (Object)objectPath);
            objectPath = this.getPathFromProjectContent(objectPath);
        }
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            TranslationProject translationProject = this.translationProjectManager.getProjectByTranslationJobId(resourceResolver, translationJobId);
            Language sourceLanguage = translationProject.getSourceLanguage();
            if (sourceLanguage == null || StringUtils.isBlank((CharSequence)sourceLanguage.getCode())) {
                LOGGER.warn("Couldn't find source language for fileUri=\"{}\".", (Object)fileUri);
                String string = objectPath;
                return string;
            }
            String targetPath = objectPath;
            if (LaunchUtils.isLaunchBasedPath((String)objectPath)) {
                targetPath = this.getLaunchSource(objectPath, resourceResolver);
            }
            LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)targetPath, (CharSequence)DAM_ROOT_FOLDER) ? this.assetLanguageCopyManager : this.pageLanguageCopyManager;
            Optional<String> sourcePath = StreamSupport.stream(languageCopyManager.findLanguageCopies(resourceResolver, targetPath).spliterator(), false).filter(languageCopy -> sourceLanguage.equals(languageCopy.getLanguage())).filter(LanguageCopyManager.LanguageCopy::exists).map(LanguageCopyManager.LanguageCopy::getPath).findFirst();
            String string = sourcePath.orElse(objectPath);
            return string;
        }
        catch (LoginException e) {
            LOGGER.error("Couldn't start session to the repository", (Throwable)e);
        }
        catch (TranslationProjectException e) {
            LOGGER.error("Failed to find translation project for fileUri=\"{}\".", (Object)fileUri, (Object)e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return objectPath;
    }

    private String getPathFromProjectContent(String objectPath) {
        if (!StringUtils.containsIgnoreCase((CharSequence)objectPath, (CharSequence)DAM_ROOT_FOLDER)) {
            return objectPath;
        }
        return DAM_ROOT_FOLDER + StringUtils.substringAfterLast((String)objectPath, (String)DAM_ROOT_FOLDER);
    }

    private String getLaunchSource(String launchPath, ResourceResolver resourceResolver) {
        Resource resource = resourceResolver.resolve(launchPath);
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            return this.getPathFromLaunch(launchPath);
        }
        Resource launchResource = LaunchUtils.getLaunchResource((Resource)resource);
        if (launchResource == null) {
            return this.getPathFromLaunch(launchPath);
        }
        return StringUtils.substringAfter((String)launchPath, (String)launchResource.getPath());
    }

    private String getPathFromLaunch(String objectPath) {
        if (!StringUtils.startsWithIgnoreCase((CharSequence)objectPath, (CharSequence)LAUNCH_ROOT_FOLDER)) {
            return objectPath;
        }
        return CONTENT_ROOT_FOLDER + StringUtils.substringAfterLast((String)objectPath, (String)CONTENT_ROOT_FOLDER);
    }
}

