/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.sync;

import com.adobe.granite.translation.api.TranslationConstants;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.core.impl.integration.sync.JobInfo;
import com.smartling.aem.connector.core.impl.integration.sync.SyncTranslationException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SyncJobInfoProvider.class})
public class SyncJobInfoProvider {
    @Reference
    private TranslationProjectManager translationProjectManager;
    private Cache<String, JobInfo> jobCache;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.jobCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    }

    public JobInfo getJobInfo(ResourceResolver resourceResolver, String translationJobId) throws SyncTranslationException {
        JobInfo jobInfo = (JobInfo)this.jobCache.getIfPresent((Object)translationJobId);
        if (jobInfo != null) {
            return jobInfo;
        }
        try {
            TranslationJob job = this.translationProjectManager.getTranslationJobById(resourceResolver, translationJobId);
            jobInfo = new JobInfo(job.getResourcePath(), job.getJobId(), job.getStatus());
            if (jobInfo.status != TranslationConstants.TranslationStatus.COMMITTED_FOR_TRANSLATION && jobInfo.status != TranslationConstants.TranslationStatus.TRANSLATION_IN_PROGRESS && jobInfo.status != TranslationConstants.TranslationStatus.SUBMITTED) {
                this.jobCache.put((Object)job.getJobId(), (Object)jobInfo);
            }
            return jobInfo;
        }
        catch (TranslationProjectException e) {
            throw new SyncTranslationException(String.format("Couldn't find translation job by id=\"%s\"", translationJobId), e);
        }
    }
}

