/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.models;

import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingProjectLocaleCredentials;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class SmartlingConfigModel {
    @Self
    private SlingHttpServletRequest request;
    @OSGiService
    private CloudConfigLocator cloudConfigLocator;
    private String configPath;
    SmartlingCloudConfig config;

    @PostConstruct
    protected void init() {
        if (this.config == null) {
            this.configPath = this.request.getRequestPathInfo().getSuffix();
            this.config = this.cloudConfigLocator.getCloudConfig(this.configPath, SmartlingCloudConfig.class);
        }
    }

    public String getProjectId() {
        this.init();
        return this.config.getProjectId();
    }

    public String getUserIdentifier() {
        this.init();
        return this.config.getUserIdentifier();
    }

    public String getTokenSecret() {
        this.init();
        return this.config.getTokenSecret();
    }

    public String getConfigPath() {
        this.init();
        return this.configPath;
    }

    public boolean getReadOnly() {
        this.init();
        return this.config.isReadOnly();
    }

    public List<SmartlingProjectLocaleCredentials> getLocaleProjectConfigs() {
        this.init();
        return this.config.getLocaleProjectConfigs();
    }
}

