/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl;

import com.day.cq.wcm.api.WCMMode;
import com.smartling.aem.connector.context.ContextConnection;
import com.smartling.aem.connector.context.ContextConnectionManager;
import com.smartling.aem.connector.context.impl.ConnectionSettings;
import com.smartling.aem.connector.context.impl.connection.GatewayConnectionFactory;
import com.smartling.aem.connector.core.ConfigurationManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingCredentials;
import com.smartling.cms.gateway.client.CmsGatewayClientException;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContextConnectionManager.class}, immediate=true)
@Designate(ocd=Config.class)
public class ContextGateway
implements ContextConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextGateway.class);
    static final String WCM_REQUEST_FILTER_PID = "com.day.cq.wcm.core.WCMRequestFilter";
    static final String WCM_MODE_PROPERTY = "wcmfilter.mode";
    static final String COMPONENT_TITLE = "Smartling - Context Connection Manager (Touch)";
    public static final String RECONNECT_SCHEDULER_JOB_NAME = "reconnect.context.connections";
    private static final boolean ENABLED_DEFAULT_VALUE = true;
    private static final int RECONNECT_PERIOD_IN_SECONDS_DEFAULT_VALUE = 1800;
    public static final int RECONNECT_AFTER_MINUTES = 5;
    @Reference
    private GatewayConnectionFactory connectionFactory;
    @Reference
    private ConfigurationManager configurationManager;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ConfigurationAdmin configAdmin;
    private boolean enabled;
    private final ConcurrentMap<String, ContextConnection> connections = new ConcurrentHashMap<String, ContextConnection>();
    private final Runnable configurationListener = new ReconnectOnConfigChangeListener();
    private final Runnable reconnectAllJob = new ReconnectAllJob();

    @Activate
    protected void activate(Config config) {
        this.enabled = config.enabled();
        int reconnectPeriod = 1800;
        try {
            reconnectPeriod = config.reconnect_period();
        }
        catch (Exception e) {
            LOGGER.error("Error while setting reconnect period. Default value '{}' was applied", (Object)1800, (Object)e);
        }
        boolean isAuthorMode = this.detectAuthorMode();
        if (!isAuthorMode) {
            LOGGER.error("AEM runs in non-author mode. Context supports Author mode only.");
            this.enabled = false;
            return;
        }
        if (this.enabled) {
            this.configurationManager.addListener(this.configurationListener);
            LOGGER.debug("Registered listener on configuration changes");
            LOGGER.info("Context is enabled and will be initialized on demand");
            LOGGER.debug("Setup scheduler for periodic context reconnection");
            Date afterDate = DateUtils.addMinutes((Date)new Date(), (int)5);
            ScheduleOptions scheduleOptions = this.scheduler.AT(afterDate, -1, (long)reconnectPeriod);
            scheduleOptions.name(RECONNECT_SCHEDULER_JOB_NAME);
            this.scheduler.schedule((Object)this.reconnectAllJob, scheduleOptions);
        } else {
            LOGGER.info("Context is disabled for this instance");
        }
    }

    @Deactivate
    protected void deactivate() {
        this.scheduler.unschedule(RECONNECT_SCHEDULER_JOB_NAME);
        LOGGER.debug("Reconnection schedule job is removed");
        this.configurationManager.removeListener(this.configurationListener);
        LOGGER.debug("Unregistered Site Config listener.");
        this.releaseConnections();
    }

    @Override
    public Future<Boolean> initializeContext() {
        if (this.enabled) {
            return this.startConnectionsAsync();
        }
        LOGGER.info("Context is disabled for this instance. Use '{}' in the Felix OSGi console to turn it on", (Object)COMPONENT_TITLE);
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public Future<Boolean> initializeContextForConfig(SmartlingCloudConfig config) {
        if (config == null) {
            LOGGER.info("Config is absent. Context cannot be initialized");
            return CompletableFuture.completedFuture(false);
        }
        if (this.enabled) {
            return this.startConnectionsAsync(config);
        }
        LOGGER.info("Context is disabled for this instance. Use '{}' in the Felix OSGi console to turn it on", (Object)COMPONENT_TITLE);
        return CompletableFuture.completedFuture(false);
    }

    void setEnabled() {
        this.enabled = true;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    private boolean initializeConnections() {
        LOGGER.trace("Opening context connection for all projects");
        Set<SmartlingCredentials> configsUniqueByProjectId = this.getConfigurationsUniqueByProjectId();
        for (SmartlingCredentials config : configsUniqueByProjectId) {
            if (this.initializeConnection(config)) continue;
            return false;
        }
        return true;
    }

    private boolean initializeConnection(SmartlingCredentials config) {
        ContextConnection connection;
        if (this.connections.containsKey(config.getProjectId())) {
            connection = (ContextConnection)this.connections.get(config.getProjectId());
        } else {
            connection = this.connectionFactory.createConnection(new ConfigConnectionSettings(config));
            this.connections.put(config.getProjectId(), connection);
        }
        try {
            LOGGER.trace("Opening context connection for projectId\"{}\"", (Object)config.getProjectId());
            connection.connect();
        }
        catch (CmsGatewayClientException e) {
            LOGGER.error("Failed to open connection:", (Throwable)e);
            this.connections.remove(config.getProjectId());
            ContextGateway.silentDisconnect(connection);
            return false;
        }
        return true;
    }

    private static void silentDisconnect(ContextConnection connection) {
        try {
            connection.disconnect();
        }
        catch (IOException e) {
            LOGGER.error("Failed to disconnect connection:", (Throwable)e);
        }
    }

    private Set<SmartlingCredentials> getConfigurationsUniqueByProjectId() {
        Collection configurations = this.configurationManager.getConfigurations();
        TreeSet<SmartlingCredentials> configsUniqueByProjectId = new TreeSet<SmartlingCredentials>(new Comparator<SmartlingCredentials>(){

            @Override
            public int compare(SmartlingCredentials config1, SmartlingCredentials config2) {
                return config1.getProjectId().compareTo(config2.getProjectId());
            }
        });
        configsUniqueByProjectId.addAll(configurations);
        return configsUniqueByProjectId;
    }

    private Future<Boolean> startConnectionsAsync() {
        Set<SmartlingCredentials> credentials = this.getConfigurationsUniqueByProjectId();
        List<CompletableFuture> resultList = credentials.stream().map(credential -> CompletableFuture.supplyAsync(() -> this.initializeConnection((SmartlingCredentials)credential))).collect(Collectors.toList());
        return CompletableFuture.allOf(resultList.toArray(new CompletableFuture[0])).thenApply(Void2 -> resultList.stream().allMatch(this::getResultSafely));
    }

    private boolean getResultSafely(CompletableFuture<Boolean> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("Couldn't open context connection", (Throwable)e);
            return false;
        }
    }

    private Future<Boolean> startConnectionsAsync(SmartlingCloudConfig config) {
        CompletableFuture<Boolean> firstResult = CompletableFuture.supplyAsync(() -> this.initializeConnection((SmartlingCredentials)config));
        List childCredentials = config.getLocaleProjectConfigs();
        if (childCredentials.isEmpty()) {
            return firstResult;
        }
        List<CompletableFuture> resultList = childCredentials.stream().map(credential -> CompletableFuture.supplyAsync(() -> this.initializeConnection((SmartlingCredentials)credential))).collect(Collectors.toList());
        resultList.add(firstResult);
        return CompletableFuture.allOf(resultList.toArray(new CompletableFuture[0])).thenApply(Void2 -> resultList.stream().allMatch(this::getResultSafely));
    }

    private void releaseConnections() {
        for (ContextConnection connection : this.connections.values()) {
            LOGGER.info("Closing connection for projectId=\"{}\".", (Object)connection.getProjectId());
            try {
                connection.disconnect();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close connection for projectId=\"{}\".", (Object)connection.getProjectId(), (Object)e);
            }
        }
        this.connections.clear();
    }

    private boolean detectAuthorMode() {
        try {
            Object defaultWcmMode;
            Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=com.day.cq.wcm.core.WCMRequestFilter)");
            if (configs != null && configs.length > 0 && (defaultWcmMode = configs[0].getProperties().get(WCM_MODE_PROPERTY)) instanceof String) {
                return !StringUtils.equalsIgnoreCase((CharSequence)WCMMode.DISABLED.name(), (CharSequence)((String)defaultWcmMode));
            }
        }
        catch (IOException | InvalidSyntaxException ex) {
            LOGGER.warn("Unable to read OSGi configuration: \"{}\".", (Object)WCM_REQUEST_FILTER_PID, (Object)ex);
        }
        return false;
    }

    static final class ConfigConnectionSettings
    implements ConnectionSettings {
        private final SmartlingCredentials config;

        ConfigConnectionSettings(SmartlingCredentials config) {
            this.config = config;
        }

        @Override
        public String getProjectId() {
            return this.config.getProjectId();
        }

        @Override
        public String getUserIdentifier() {
            return this.config.getUserIdentifier();
        }

        @Override
        public String getTokenSecret() {
            return this.config.getTokenSecret();
        }
    }

    private final class ReconnectAllJob
    implements Runnable {
        private ReconnectAllJob() {
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Making connections for all configs");
                ContextGateway.this.startConnectionsAsync().get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.error("Couldn't reconnect all contexts", (Throwable)e);
            }
        }
    }

    private final class ReconnectOnConfigChangeListener
    implements Runnable {
        private ReconnectOnConfigChangeListener() {
        }

        @Override
        public void run() {
            try {
                if (ContextGateway.this.connections.isEmpty()) {
                    LOGGER.debug("Smartling connector configurations have been changed, but there's no connections to refresh");
                } else {
                    LOGGER.info("Smartling connector configurations have been changed. Triggering connections refresh...");
                    ContextGateway.this.releaseConnections();
                    ContextGateway.this.startConnectionsAsync().get(5L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.error("Couldn't reconnect on config changes", (Throwable)e);
            }
        }
    }

    private final class StartConnectionsTask
    implements Callable<Boolean> {
        private final SmartlingCredentials config;

        StartConnectionsTask(SmartlingCredentials config) {
            this.config = config;
        }

        @Override
        public Boolean call() {
            return this.config == null ? ContextGateway.this.initializeConnections() : ContextGateway.this.initializeConnection(this.config);
        }
    }

    @ObjectClassDefinition(name="Smartling - Context Connection Manager (Touch)", description="Establishes and controls connections to Smartling to support context.")
    public static @interface Config {
        @AttributeDefinition(name="Enabled", description="Enables / Disables the feature")
        public boolean enabled() default true;

        @AttributeDefinition(name="Reconnect period", description="Reconnect period in seconds")
        public int reconnect_period() default 1800;
    }
}

