/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection;

import com.smartling.aem.connector.context.impl.connection.ResourceLoadingHandler;
import com.smartling.aem.connector.context.impl.resources.ResourceLoader;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingException;
import com.smartling.aem.connector.context.impl.resources.ResourceStream;
import com.smartling.aem.connector.core.FileUriResolver;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.cms.gateway.client.CmsGatewayClient;
import com.smartling.cms.gateway.client.CmsGatewayClientException;
import com.smartling.cms.gateway.client.command.BaseCommand;
import com.smartling.cms.gateway.client.command.ErrorResponse;
import com.smartling.cms.gateway.client.command.GetHtmlCommand;
import com.smartling.cms.gateway.client.command.GetResourceCommand;
import com.smartling.cms.gateway.client.upload.FileUpload;
import com.smartling.cms.gateway.client.upload.HtmlUpload;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoadingHandlerImpl
implements ResourceLoadingHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLoadingHandlerImpl.class);
    private final ResourceLoader resourcesFacade;
    private final FileUriResolver fileUriResolver;

    public ResourceLoadingHandlerImpl(ResourceLoader resourcesFacade, FileUriResolver fileUriResolver) {
        this.resourcesFacade = Objects.requireNonNull(resourcesFacade);
        this.fileUriResolver = Objects.requireNonNull(fileUriResolver);
    }

    @Override
    public void loadHtml(CmsGatewayClient client, GetHtmlCommand command) {
        LOGGER.debug("Got GetHtmlCommand command '{}'", (Object)command);
        try {
            String path = this.fileUriResolver.getPathByFileUri(command.getUri(), this.resourcesFacade.takePreviewFromSource());
            if (ResourceLoadingHandlerImpl.isPagePath(path)) {
                this.loadPage(client, (BaseCommand)command, path);
            } else {
                LOGGER.info("File fileUri=\"{}\" does not correspond to any page", (Object)command.getUri());
                ResourceLoadingHandlerImpl.sendError(client, (BaseCommand)command, "It's not possible to provide context for this file");
            }
        }
        catch (SmartlingException e) {
            LOGGER.error("Could not find page for fileUri=\"{}\"", (Object)command.getUri(), (Object)e);
            ResourceLoadingHandlerImpl.sendError(client, (BaseCommand)command, (Exception)((Object)e));
        }
    }

    private static boolean isPagePath(String path) {
        return path.startsWith("/content");
    }

    private static boolean isDamPath(String path) {
        return StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"/content/dam");
    }

    private void loadPage(CmsGatewayClient client, BaseCommand command, String path) {
        try {
            String tailedPath = this.buildTailedPath(path);
            ResourceStream stream = this.resourcesFacade.loadResource(tailedPath);
            HtmlUpload response = new HtmlUpload(command);
            response.setBaseUrl(stream.getBaseUrl());
            response.setBody(IOUtils.toString((InputStream)stream.getContentStream(), (String)stream.getEncoding()));
            this.sendResponse(client, command, (FileUpload)response);
        }
        catch (ResourceLoadingException | IOException | RuntimeException e) {
            LOGGER.error("Could not load page with path=\"{}\"", (Object)path, (Object)e);
            ResourceLoadingHandlerImpl.sendError(client, command, e);
        }
    }

    @Override
    public String buildTailedPath(String path) {
        String tail = "?wcmmode=" + this.resourcesFacade.getWcmmode();
        if (!ResourceLoadingHandlerImpl.isDamPath(path)) {
            tail = ".html" + tail;
        }
        return path + tail;
    }

    @Override
    public void loadResource(CmsGatewayClient client, GetResourceCommand command) {
        LOGGER.debug("Got GetResourceCommand command '{}'", (Object)command);
        try {
            String path = this.fileUriResolver.getPathByFileUri(command.getUri(), this.resourcesFacade.takePreviewFromSource());
            ResourceStream stream = this.resourcesFacade.loadResource(path);
            FileUpload response = new FileUpload((BaseCommand)command);
            response.setContentStream(stream.getContentStream());
            response.setContentType(stream.getContentType(), null);
            this.sendResponse(client, (BaseCommand)command, response);
        }
        catch (ResourceLoadingException | SmartlingException | RuntimeException e) {
            LOGGER.warn("Could not load resource uri=\"{}\"", (Object)command.getUri(), (Object)e);
            ResourceLoadingHandlerImpl.sendError(client, (BaseCommand)command, (Exception)e);
        }
    }

    private void sendResponse(CmsGatewayClient client, BaseCommand command, FileUpload response) {
        try {
            LOGGER.debug("Sending response for command '{}'", (Object)command);
            client.send(response);
        }
        catch (CmsGatewayClientException | IOException e) {
            LOGGER.error("Failed to send response for command '{}'", (Object)command, (Object)e);
        }
    }

    private static void sendError(CmsGatewayClient client, BaseCommand command, Exception e) {
        ArrayList<Exception> causes = new ArrayList<Exception>(4);
        for (Throwable throwable = e; throwable != null; throwable = throwable.getCause()) {
            causes.add((Exception)throwable);
        }
        String[] messages = (String[])causes.stream().map(Throwable::toString).toArray(String[]::new);
        ResourceLoadingHandlerImpl.sendError(client, command, messages);
    }

    private static void sendError(CmsGatewayClient client, BaseCommand command, String ... messages) {
        LOGGER.debug("Sending error for command {}: {}", (Object)command, (Object)messages);
        ErrorResponse error = new ErrorResponse(command);
        for (String message : messages) {
            error.addErrorMessage(message);
        }
        client.send(error);
    }
}

