/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.resources.http;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.smartling.aem.connector.context.impl.resources.ResourceLoader;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingConnectionException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingCredentialsException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingLoginException;
import com.smartling.aem.connector.context.impl.resources.ResourceStream;
import com.smartling.aem.connector.context.impl.resources.render.ResourceRenderer;
import com.smartling.aem.connector.core.NetworkSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceLoader.class})
@Designate(ocd=Config.class)
public class HttpResourceLoader
implements ResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceLoader.class);
    static final String CONFIGURATION_NAME = "Smartling - Context Preview Settings (Touch)";
    public static final String MISSING_CREDENTIAL_CONFIGURATION_ERROR_MESSAGE = "Missing credential configuration for resource loading";
    public static final String INTERNAL_ERROR_MESSAGE = "Failed to load resource: internal error";
    public static final String URL_WRONG_FORMAT_ERROR = "Failed to load resource: URL \"%s\" has wrong format";
    public static final String RESOURCE_LOCAL_ERROR = "Couldn't determine is resource \"%s\" local or not. Mandatory configuration for server URL is empty.";
    private static final int CONNECTION_TIMEOUT_MIN = 2000;
    private static final int CONNECTION_TIMEOUT_MAX = 10000;
    private static final int SOCKET_TIMEOUT_MIN = 10000;
    private static final int SOCKET_TIMEOUT_MAX = 20000;
    private static final String WCMMODE_DEFAULT = "disabled";
    private static final boolean TAKE_FROM_SOURCE_DEFAULT = false;
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private NetworkSettings networkSettings;
    @Reference
    private ResourceRenderer nativeResourceRenderer;
    private String serverUrl;
    private String username;
    private String password;
    private boolean useNativeRendering;
    private int connectionTimeout;
    private int socketTimeout;
    private String wcmmode;
    private boolean previewFromSource = false;

    @Activate
    protected void activate(Config config) throws Exception {
        String rawServerUrl = config.server_url();
        this.serverUrl = StringUtils.removeEnd((String)rawServerUrl, (String)"/");
        this.username = config.user_name();
        this.password = config.user_password();
        this.useNativeRendering = config.direct_rendering();
        this.previewFromSource = config.preview_from_source();
        this.connectionTimeout = 2000;
        try {
            this.connectionTimeout = Math.max(config.connection_timeout(), 2000);
            this.connectionTimeout = Math.min(this.connectionTimeout, 10000);
        }
        catch (Exception e) {
            LOGGER.error("Error while setting connection timeout. Default value '{}' was applied", (Object)2000, (Object)e);
        }
        this.socketTimeout = 10000;
        try {
            this.socketTimeout = Math.max(config.socket_timout(), 10000);
            this.socketTimeout = Math.min(this.socketTimeout, 20000);
        }
        catch (Exception e) {
            LOGGER.error("Error while setting socket timeout. Default value '{}' was applied", (Object)10000, (Object)e);
        }
        if (StringUtils.isEmpty((CharSequence)this.serverUrl)) {
            LOGGER.error("Missing mandatory \"serverUrl\" OSGi option.");
        }
        if (this.useNativeRendering) {
            LOGGER.info("Direct resource rendering for local resources is turned on");
        } else {
            if (StringUtils.isEmpty((CharSequence)this.username) || StringUtils.isEmpty((CharSequence)this.password)) {
                LOGGER.error("Missing mandatory credentials options.");
            }
            try {
                if (this.cryptoSupport.isProtected(this.password)) {
                    this.password = this.cryptoSupport.unprotect(this.password);
                } else {
                    LOGGER.warn("Unprotected password is used in '{}' configuration.", (Object)CONFIGURATION_NAME);
                }
            }
            catch (CryptoException e) {
                LOGGER.error("Failed to unprotect password.", (Throwable)e);
            }
        }
        this.wcmmode = config.request_wcmmode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceStream loadResource(String uri) throws ResourceLoadingException {
        String url = this.buildFullUrl(uri);
        try {
            LOGGER.info("Started to load resource for fileUri=\"{}\"", (Object)url);
            long startTime = System.nanoTime();
            try {
                if (!this.isLocalResource(url)) {
                    ResourceStream resourceStream = this.loadExternalResource(url);
                    return resourceStream;
                }
                if (this.useNativeRendering) {
                    ResourceStream resourceStream = this.nativeResourceRenderer.renderResource(uri, this.serverUrl);
                    return resourceStream;
                }
                ResourceStream resourceStream = this.loadLocalResource(url);
                return resourceStream;
            }
            finally {
                long elapsedTime = (System.nanoTime() - startTime) / 1000000L;
                LOGGER.info("Loading of resource fileUri=\"{}\" is completed in elapsedTime=\"{}\" ms", (Object)url, (Object)elapsedTime);
            }
        }
        catch (HttpHostConnectException e) {
            throw new ResourceLoadingConnectionException(INTERNAL_ERROR_MESSAGE, (IOException)((Object)e));
        }
        catch (IOException e) {
            throw new ResourceLoadingException(INTERNAL_ERROR_MESSAGE, e);
        }
        catch (URISyntaxException e) {
            throw new ResourceLoadingException(String.format(URL_WRONG_FORMAT_ERROR, url), e);
        }
    }

    @Override
    public boolean takePreviewFromSource() {
        return this.previewFromSource;
    }

    private ResourceStream loadLocalResource(String url) throws ResourceLoadingException, IOException, URISyntaxException {
        try (CloseableHttpClient httpClient = this.createHttpClient();){
            this.logIn(httpClient);
            ResourceStream resourceStream = this.loadResource(url, httpClient);
            return resourceStream;
        }
    }

    private ResourceStream loadExternalResource(String url) throws ResourceLoadingException, IOException, URISyntaxException {
        try (CloseableHttpClient httpClient = this.createHttpClient();){
            ResourceStream resourceStream = this.loadResource(url, httpClient);
            return resourceStream;
        }
    }

    private boolean isLocalResource(String url) throws ResourceLoadingException {
        if (StringUtils.isBlank((CharSequence)this.serverUrl)) {
            throw new ResourceLoadingException(String.format(RESOURCE_LOCAL_ERROR, url));
        }
        return StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)this.serverUrl);
    }

    @Override
    public String getWcmmode() {
        return this.wcmmode;
    }

    private ResourceStream loadResource(String url, CloseableHttpClient httpClient) throws ResourceLoadingException, IOException, URISyntaxException {
        URI uri = this.decodeFullUrl(url);
        LOGGER.debug("Loading resource uri=\"{}\"", (Object)uri);
        HttpGet request = new HttpGet(uri);
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                ResourceStream resourceStream = HttpResourceLoader.createResourceStream((HttpResponse)response, url);
                return resourceStream;
            }
            try {
                throw new ResourceLoadingException(String.format("Could not load resource url=\"%s\". HTTP code: %d. Response headers %s. Body:\n%s", url, status, HttpResourceLoader.getHeaders((HttpMessage)response), HttpResourceLoader.getContentFirstPart((HttpResponse)response, 500)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static String decodeUrl(String url) throws ResourceLoadingException {
        try {
            String decodedUrl = url;
            while (!StringUtils.equals((CharSequence)(decodedUrl = URLDecoder.decode(url = decodedUrl, StandardCharsets.UTF_8.toString())), (CharSequence)url)) {
            }
            return decodedUrl;
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            throw new ResourceLoadingException(String.format(URL_WRONG_FORMAT_ERROR, url), e);
        }
    }

    private URI decodeFullUrl(String url) throws ResourceLoadingException, IOException, URISyntaxException {
        String decodedUrl = HttpResourceLoader.decodeUrl(url);
        URL parsedUrl = new URL(decodedUrl);
        return new URI(parsedUrl.getProtocol(), parsedUrl.getUserInfo(), parsedUrl.getHost(), parsedUrl.getPort(), parsedUrl.getPath(), parsedUrl.getQuery(), parsedUrl.getRef());
    }

    private void logIn(CloseableHttpClient httpClient) throws ResourceLoadingException, IOException {
        LOGGER.debug("Logging in to host=\"{}\" as user=\"{}\"", (Object)this.serverUrl, (Object)this.username);
        if (StringUtils.isEmpty((CharSequence)this.serverUrl) || StringUtils.isEmpty((CharSequence)this.username) || StringUtils.isEmpty((CharSequence)this.password)) {
            LOGGER.error(MISSING_CREDENTIAL_CONFIGURATION_ERROR_MESSAGE);
            throw new ResourceLoadingCredentialsException("Failed to log in. Missing credential configuration for resource loading");
        }
        HttpPost loginRequest = new HttpPost(this.serverUrl + "/libs/granite/core/content/login/j_security_check");
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("j_username", this.username));
        parameters.add(new BasicNameValuePair("j_password", this.password));
        loginRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)loginRequest);){
            int status = response.getStatusLine().getStatusCode();
            if (status >= 400) {
                throw new ResourceLoadingLoginException(String.format("Failed to log in. HTTP code: %d. Response headers %s. Body:\n%s", status, HttpResourceLoader.getHeaders((HttpMessage)response), HttpResourceLoader.getContentFirstPart((HttpResponse)response, 500)));
            }
        }
    }

    private CloseableHttpClient createHttpClient() {
        RequestConfig requestConfigWithTimeouts = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.socketTimeout).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfigWithTimeouts);
        if (this.networkSettings.isProxyEnabled()) {
            HttpHost proxyHost = new HttpHost(this.networkSettings.getProxyHost(), this.networkSettings.getProxyPort().intValue());
            httpClientBuilder = httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new ExcludingLocalProxyRoutePlanner(proxyHost));
            if (this.networkSettings.requireProxyAuthentication()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(this.networkSettings.getProxyUser(), this.networkSettings.getProxyPassword()));
                httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return httpClientBuilder.build();
    }

    private static ResourceStream createResourceStream(HttpResponse response, String url) throws IOException {
        String contentType = HttpResourceLoader.getHeaderValueOrNull(response.getEntity().getContentType());
        String encoding = HttpResourceLoader.getEncoding(response);
        ByteArrayInputStream stream = new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
        ResourceStream resourceStream = new ResourceStream(stream, encoding, contentType);
        resourceStream.setBaseUrl(url);
        return resourceStream;
    }

    private static String getHeaderValueOrNull(Header header) {
        return header != null ? header.getValue() : null;
    }

    private static String getEncoding(HttpResponse response) {
        String encoding = HttpResourceLoader.getHeaderValueOrNull(response.getEntity().getContentEncoding());
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
            encoding = contentType != null && contentType.getCharset() != null ? contentType.getCharset().name() : Consts.UTF_8.name();
        }
        return encoding;
    }

    private static String getContentFirstPart(HttpResponse response, int size) throws IOException {
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)HttpResourceLoader.getEncoding(response));
        return StringUtils.substring((String)responseBody, (int)0, (int)size);
    }

    private static String getHeaders(HttpMessage message) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Header header : message.getAllHeaders()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(String.format("name=\"%s\": value=\"%s\"", header.getName(), header.getValue()));
        }
        return sb.toString();
    }

    private String buildFullUrl(String uri) {
        if (uri.matches("/[\\w,\\W]*")) {
            if (this.serverUrl.startsWith("http://localhost")) {
                LOGGER.warn("Using localhost as a server URL may break page context. See {} OSGi configuration", (Object)CONFIGURATION_NAME);
            }
            return this.serverUrl + uri;
        }
        return uri;
    }

    private final class ExcludingLocalProxyRoutePlanner
    extends DefaultProxyRoutePlanner {
        ExcludingLocalProxyRoutePlanner(HttpHost proxyHost) {
            super(proxyHost);
        }

        protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
            if (target.getHostName().equals(URI.create(HttpResourceLoader.this.serverUrl).getHost())) {
                return null;
            }
            return super.determineProxy(target, request, context);
        }
    }

    @ObjectClassDefinition(name="Smartling - Context Preview Settings (Touch)", description="Configure, how translators will preview pages in TMS. Mandatory to have context working.")
    public static @interface Config {
        @AttributeDefinition(name="Use direct rendering", description="Direct rendering allows do not use user/host")
        public boolean direct_rendering() default true;

        @AttributeDefinition(name="Server URL", description="Format: http://<host>:<port> OR https://<host>:<port>. Please, note that localhost and 127.0.0.1 are NOT supported.")
        public String server_url() default "";

        @AttributeDefinition(name="User", description="AEM User, used to capture context")
        public String user_name() default "";

        @AttributeDefinition(name="Password", description="AEM User password, used to capture context")
        public String user_password() default "";

        @AttributeDefinition(name="Connection timeout", description="Connection timeout in milliseconds")
        public int connection_timeout() default 2000;

        @AttributeDefinition(name="Socket timeout", description="Socket timeout in milliseconds")
        public int socket_timout() default 10000;

        @AttributeDefinition(name="Preview WCMMODE", description="This mode is used for requesting a context")
        public String request_wcmmode() default "disabled";

        @AttributeDefinition(name="Take preview from source content", description="Enables / Disables taking a context preview from source. For pages and experience fragments context preview is taken from accorded launches by default.")
        public boolean preview_from_source() default false;
    }
}

