;(function (document, $, page) {
    $(document).ready(function(){
        var bindTranslateMenuItem = function () {
            var SMARTLING_MENU_ITEM_BOUND_CLASS = 'smartling-menu-item-bound';
            var $translateAsJobMenuItem = $('#smartling-job-trigger');

            // Hack to support both AEM 6.2 and 6.3:
            //    6.2: uses minimal buttons
            //    6.3: uses regular buttons
            // So we check which button style is used by the previous menu item
            if ($translateAsJobMenuItem.prev().hasClass('coral-MinimalButton')) {
                $translateAsJobMenuItem.removeClass('coral-Button');
                $translateAsJobMenuItem.addClass('coral-MinimalButton');
            }
            if (!$translateAsJobMenuItem.hasClass(SMARTLING_MENU_ITEM_BOUND_CLASS)) {
                $translateAsJobMenuItem.addClass(SMARTLING_MENU_ITEM_BOUND_CLASS)
                $translateAsJobMenuItem.click(function () {
                    window.smartling.touchui.jobDialog.openDialog(page.path);
                });
            }
        };
        var pageInfoPopover = document.find("#pageinfo-popover");
        var observerConfig  = { attributes: true, childList: true, subtree: true };
        var observer = new MutationObserver(bindTranslateMenuItem);
        pageInfoPopover.each(function() {
            observer.observe(this, observerConfig);
        });

        window.smartling.touchui.jobDialog.initializeForm('/services/smartling/job/workflows/page');

        // Granite.author.getPageInfoLocation() is a part of public Granite API
        // https://helpx.adobe.com/experience-manager/6-5/sites/developing/using/reference-materials/jsdoc/ui-touch/editor-core/Granite.author.html#getPageInfoLocation__anchor
        var path = Granite.author.getPageInfoLocation();
        window.smartling.touchui.jobDialog.setPayload(path);
        window.smartling.touchui.jobDialog.loadProjects(path);
        window.smartling.touchui.jobDialog.setReuseProjectSelectData(true);
    });

})(jQuery(document), Granite.$, Granite.author.page);
