/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl;

import com.day.cq.commons.LanguageUtil;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class Language {
    private final String code;
    private final String displayName;

    private Language(String code, String displayName) {
        this.code = Objects.requireNonNull(code, "Language code can not be null");
        this.displayName = Objects.requireNonNull(displayName, "Language display name can not be null");
    }

    public static Language forCode(String code) {
        Locale locale = LanguageUtil.getLocale((String)code);
        return Language.create(code, locale != null ? locale.getDisplayName() : code);
    }

    public static Language create(String code, String displayName) {
        return new Language(code, displayName);
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Language anotherLanguage = (Language)object;
        return StringUtils.equalsIgnoreCase((CharSequence)this.code, (CharSequence)anotherLanguage.code) || StringUtils.equalsIgnoreCase((CharSequence)StringUtils.replace((String)this.code, (String)"-", (String)"_"), (CharSequence)StringUtils.replace((String)anotherLanguage.code, (String)"-", (String)"_"));
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public String toString() {
        return this.displayName + " [" + this.code + "]";
    }
}

