/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl;

import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.CloudConfigResolver;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.CustomField;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ProjectCustomFieldsProvider.class}, immediate=true)
@Designate(ocd=Config.class)
public class ProjectCustomFieldsProvider {
    private static final Set<String> ALLOWED_CUSTOM_FIELD_TYPES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    @Reference
    private JobApiClientFactory clientFactory;
    @Reference
    private CloudConfigLocator cloudConfigLocator;
    @Reference
    private CloudConfigResolver cloudConfigResolver;
    private List<String> allowedCustomFields;

    @Activate
    protected void activate(Config config) {
        this.allowedCustomFields = Arrays.asList(config.allowedCustomFields());
        ALLOWED_CUSTOM_FIELD_TYPES.add("SHORT_TEXT");
        ALLOWED_CUSTOM_FIELD_TYPES.add("LONG_TEXT");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CustomField> getAssignedCustomFields(Resource resource, String projectUid) throws SmartlingException {
        SmartlingCloudConfig cloudConfig = this.getSmartlingConfig(resource, projectUid);
        try (JobApiClient client = this.clientFactory.createClient(cloudConfig);){
            List<CustomField> customFields = client.listProjectCustomFields(cloudConfig.getProjectId());
            List<CustomField> list = this.allowedCustomFields.stream().map(allowedCustomField -> customFields.stream().filter(customField -> StringUtils.equalsAnyIgnoreCase((CharSequence)customField.getFieldName(), (CharSequence[])new CharSequence[]{allowedCustomField})).findFirst()).filter(Optional::isPresent).map(Optional::get).filter(customField -> ALLOWED_CUSTOM_FIELD_TYPES.contains(customField.getFieldType())).collect(Collectors.toList());
            return list;
        }
        catch (Exception ex) {
            throw new SmartlingException("Couldn't list project custom fields for project=\"" + projectUid + "\".", ex);
        }
    }

    private SmartlingCloudConfig getSmartlingConfig(Resource resource, String projectUid) {
        SmartlingCloudConfig cloudConfig = this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, SmartlingCloudConfig.class);
        if (cloudConfig == null) {
            throw new IllegalArgumentException("The resource=\"" + resource.getPath() + "\" does not have any Smartling Cloud Config associated with it");
        }
        return this.cloudConfigResolver.getConfigByResource(cloudConfig, resource, projectUid);
    }

    @ObjectClassDefinition(name="Smartling - Jobs Custom Fields settings (Touch)", description="Displays Smartling Jobs Custom Fields right in Request Translation dialog. You should configure at least one existing custom filed (only \"Short Text\" types are supported)")
    public static @interface Config {
        @AttributeDefinition(name="Show custom fields", description="Put Title of custom fields to show them in Smartling Request Translation dialog")
        public String[] allowedCustomFields() default {};
    }
}

