/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.smartling.aem.connector.automation.impl.related.NodeFilterRule;
import com.smartling.aem.connector.automation.impl.related.PropertyRule;
import com.smartling.aem.connector.automation.impl.related.TranslatableNode;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.RepositoryException;

public class NodeRule {
    private boolean bCacheValid = false;
    private final String strNodePath;
    private final String strResourceType;
    private final String strNodePathContains;
    private final ArrayList<NodeFilterRule> filterRules;
    private final HashMap<String, PropertyRule> inheritablePropertyHash;
    private final HashMap<String, PropertyRule> privatePropertyHash;
    private ArrayList<String> strCachedTranslatablePropertyList;

    NodeRule(String strNodePath, String strResourceType, String strNodePathContains) {
        this.strNodePath = strNodePath;
        this.strResourceType = strResourceType;
        this.strNodePathContains = strNodePathContains;
        this.strCachedTranslatablePropertyList = null;
        this.filterRules = new ArrayList();
        this.inheritablePropertyHash = new HashMap();
        this.privatePropertyHash = new HashMap();
    }

    public String getStrNodePath() {
        return this.strNodePath;
    }

    public String getStrResourceType() {
        return this.strResourceType;
    }

    public String getStrNodePathContains() {
        return this.strNodePathContains;
    }

    public ArrayList<String> getTranslatablePropertyList() {
        if (!this.bCacheValid || this.strCachedTranslatablePropertyList == null) {
            this.strCachedTranslatablePropertyList = new ArrayList();
            this.addPropertyToCacheList(this.inheritablePropertyHash, this.strCachedTranslatablePropertyList);
            this.addPropertyToCacheList(this.privatePropertyHash, this.strCachedTranslatablePropertyList);
            this.bCacheValid = true;
        }
        return this.strCachedTranslatablePropertyList;
    }

    private void addPropertyToCacheList(HashMap<String, PropertyRule> propertyHash, ArrayList<String> strPropertyList) {
        for (String key : propertyHash.keySet()) {
            PropertyRule rule = propertyHash.get(key);
            boolean bCheckValue = rule.isbTranslate();
            if (bCheckValue) {
                if (strPropertyList.contains(rule.getStrPropertyName())) continue;
                strPropertyList.add(rule.getStrPropertyName());
                continue;
            }
            strPropertyList.remove(rule.getStrPropertyName());
        }
    }

    public boolean isValidBasedOnFilters(TranslatableNode node) throws RepositoryException {
        boolean bValid = true;
        for (NodeFilterRule filterRule : this.filterRules) {
            if (filterRule.isValidBasedOnFilter(node)) continue;
            bValid = false;
            break;
        }
        return bValid;
    }

    public void copyRules(NodeRule parentRule) {
        if (parentRule != null) {
            for (String key : parentRule.inheritablePropertyHash.keySet()) {
                PropertyRule currentRule = parentRule.inheritablePropertyHash.get(key);
                this.inheritablePropertyHash.put(key, currentRule.duplicate());
            }
            NodeFilterRule.copyFilters(this.filterRules, parentRule.filterRules);
        }
    }

    public void addFilterNode(String strPathContains, String strContainsProperty, String strPropertyValue, boolean bIsDeep) {
        NodeFilterRule newFilter = new NodeFilterRule(strPathContains, strContainsProperty, strPropertyValue, bIsDeep);
        this.filterRules.add(newFilter);
    }

    public void processProperty(String strPropertyName, boolean bInheritable, boolean bTranslate, boolean bPatchLanguage) {
        if (bPatchLanguage) {
            bTranslate = false;
        }
        this.bCacheValid = false;
        if (bTranslate) {
            PropertyRule newRule = new PropertyRule(strPropertyName, true, false);
            if (bInheritable) {
                this.inheritablePropertyHash.put(strPropertyName, newRule);
            } else {
                this.privatePropertyHash.put(strPropertyName, newRule);
            }
        } else {
            this.inheritablePropertyHash.remove(strPropertyName);
            this.privatePropertyHash.remove(strPropertyName);
        }
    }
}

