/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.MachineTranslationUtil;
import com.day.cq.dam.api.Asset;
import com.day.text.ISO9075;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelatedAssetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedAssetUtils.class);
    public static final String ETC_WORKFLOW_MODELS_TRANSLATION_TRANSLATION_RULES_XML = "/etc/workflow/models/translation/translation_rules.xml";
    private static final String[] RULE_FILES_PRIORITY_ARRAY = new String[]{"/conf/global/settings/translation/rules/translation_rules.xml", "/apps/settings/translation/rules/translation_rules.xml", "/etc/workflow/models/translation/translation_rules.xml", "/libs/settings/translation/rules/translation_rules.xml"};
    public static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    public static final String JCR_CONTENT_JCR_DATA = "jcr:content/jcr:data";
    public static final String TEXT_HTML = "text/html";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_MIME_TYPE = "jcr:mimeType";
    public static final String JCR_DATA = "jcr:data";
    public static final String CQ_PAGE = "cq:Page";
    public static final String CONTENT_FRAGMENT = "contentFragment";

    static boolean isNodeOfPrimaryType(Node node, String strNodePrimaryType) {
        String strVal;
        boolean bRetVal = false;
        if (node != null && (strVal = RelatedAssetUtils.getStringAttribute(LOGGER, node, JCR_PRIMARY_TYPE, null)) != null) {
            bRetVal = strNodePrimaryType.equals(strVal);
        }
        return bRetVal;
    }

    static HashSet<Asset> getEmbeddedAssets(String contentFragmentNodePath, ResourceResolver resourceResolver) throws RepositoryException, IOException {
        LOGGER.debug("In Function: getEmbeddedAssets");
        HashSet<Asset> embeddedAssets = new HashSet<Asset>();
        NodeIterator ntFileNodes = RelatedAssetUtils.getAllNtFilesAtPath(resourceResolver, contentFragmentNodePath, LOGGER);
        if (ntFileNodes != null) {
            while (ntFileNodes.hasNext()) {
                Property variationProperty;
                String variationData;
                Node variationNode = ntFileNodes.nextNode();
                String mimeType = RelatedAssetUtils.getMimeType(variationNode);
                String jcrDataProperty = JCR_CONTENT_JCR_DATA;
                if (!mimeType.equals(TEXT_HTML) || !variationNode.hasProperty(jcrDataProperty) || StringUtils.isEmpty((CharSequence)(variationData = RelatedAssetUtils.getVariationData(variationProperty = variationNode.getProperty(jcrDataProperty))))) continue;
                HashSet<Asset> embeddedAssetsForVariation = RelatedAssetUtils.getEmbeddedAssetsForVariation(variationData, resourceResolver);
                embeddedAssets.addAll(embeddedAssetsForVariation);
            }
        }
        return embeddedAssets;
    }

    private static HashSet<Asset> getEmbeddedAssetsForVariation(String variationData, ResourceResolver resourceResolver) {
        LOGGER.debug("In Function: getEmbeddedAssetsForVariation");
        HashSet<Asset> embeddedAssets = new HashSet<Asset>();
        HashSet<String> assetPaths = RelatedAssetUtils.getEmbeddedAssetPaths(variationData);
        for (String assetPath : assetPaths) {
            Asset asset;
            Resource resource = resourceResolver.getResource(RelatedAssetUtils.decodeURL(assetPath));
            if (null == resource || null == (asset = (Asset)resource.adaptTo(Asset.class))) continue;
            embeddedAssets.add(asset);
        }
        return embeddedAssets;
    }

    private static String decodeURL(String url) {
        try {
            return URIUtil.decode((String)url);
        }
        catch (URIException e) {
            LOGGER.error("could not decode url : {}", (Object)url, (Object)e);
            return url;
        }
    }

    private static HashSet<String> getEmbeddedAssetPaths(String variationData) {
        LOGGER.debug("In Function: getEmbeddedAssetPaths");
        HashSet<String> assetPaths = new HashSet<String>();
        String regEx = RelatedAssetUtils.getRegexForInlineMediaAssets();
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(variationData);
        while (matcher.find()) {
            assetPaths.add(matcher.group(RelatedAssetUtils.getRegexGroupInlineMediaAssets()));
        }
        return assetPaths;
    }

    private static int getRegexGroupInlineMediaAssets() {
        return 4;
    }

    private static String getRegexForInlineMediaAssets() {
        return "<[\\n ]*img[\\n ]*(([a-zA-Z-]+[\\n ]*=[\\n ]*\"[\\n ]*([^>\"\\n]+)[\\n ]*\")* *)*[\\n ]*src[\\n ]*=[\\n ]*\"[\\n ]*([^>\" \\n]+)[\\n ]*\"[\\n ]*(([a-zA-Z-]+[\\n ]*=[\\n ]*\"[\\n ]*([^>\"\\n]+)[\\n ]*\")* *)*[\\n ]*\\/?[\\n ]*>";
    }

    static String getVariationData(Property variationProperty) throws RepositoryException, IOException {
        String variationData;
        try (InputStream is = variationProperty.getValue().getBinary().getStream();){
            variationData = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        return variationData;
    }

    private static String getMimeType(Node variation) throws RepositoryException {
        Node contentNode;
        String retVal = "";
        if (variation.hasNode(JCR_CONTENT) && (contentNode = variation.getNode(JCR_CONTENT)).hasProperty(JCR_MIME_TYPE)) {
            retVal = contentNode.getProperty(JCR_MIME_TYPE).getString();
        }
        return retVal;
    }

    public static NodeIterator getAllNtFilesAtPath(ResourceResolver resolver, String path, Logger logger) {
        logger.trace("In function: getAllNtFilesAtPath path:{}", (Object)path);
        try {
            Session session = (Session)resolver.adaptTo(Session.class);
            QueryManager qm = session.getWorkspace().getQueryManager();
            QueryResult result = qm.createQuery("/jcr:root" + ISO9075.encodePath((String)path) + "//element(*, nt:file)", "xpath").execute();
            return result.getNodes();
        }
        catch (RepositoryException e) {
            logger.error("Can't get nt:file from {}", (Object)path, (Object)e);
            return null;
        }
    }

    public static String getStringAttribute(Logger logger, Node node, String strAttributeName, String strDefaultValue) {
        block3: {
            try {
                Property property;
                if (node.hasProperty(strAttributeName) && (property = node.getProperty(strAttributeName)) != null) {
                    return property.getString();
                }
            }
            catch (RepositoryException ex) {
                if (logger == null) break block3;
                logger.error("Error while fetching string attribute " + strAttributeName, (Throwable)ex);
            }
        }
        return strDefaultValue;
    }

    public static String getNodeResourceType(Logger logger, Node node, String strDefaultValue) {
        return RelatedAssetUtils.getStringAttribute(logger, node, "sling:resourceType", strDefaultValue);
    }

    public static boolean isBinaryNode(Node node) throws RepositoryException {
        Property prop;
        boolean bBinaryNode = false;
        if (node != null && node.hasProperty(JCR_DATA) && (prop = node.getProperty(JCR_DATA)) != null && prop.getType() == 2) {
            bBinaryNode = true;
        }
        return bBinaryNode;
    }

    static boolean isPageNode(Node node) {
        return RelatedAssetUtils.isNodeOfPrimaryType(node, CQ_PAGE);
    }

    static boolean getBooleanAttributeFromContent(Node node, String strAttributeName, boolean bDefault) {
        try {
            Property property;
            Node contentNode;
            if (node.hasNode(JCR_CONTENT) && (contentNode = node.getNode(JCR_CONTENT)) != null && contentNode.hasProperty(strAttributeName) && (property = contentNode.getProperty(strAttributeName)).getType() == 6) {
                bDefault = property.getBoolean();
            }
        }
        catch (RepositoryException ex) {
            LOGGER.error("Error while fetching boolean attribute " + strAttributeName, (Throwable)ex);
        }
        return bDefault;
    }

    public static boolean isContentFragment(Node resourceNode) {
        try {
            Node resourceNodeContent;
            if (resourceNode.hasNode(JCR_CONTENT) && (resourceNodeContent = resourceNode.getNode(JCR_CONTENT)) != null && resourceNodeContent.hasProperty(CONTENT_FRAGMENT)) {
                return resourceNodeContent.getProperty(CONTENT_FRAGMENT).getBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getTranslationRulesFileLocation(ResourceResolver resolver) {
        String strRetVal = null;
        for (String strCurrentPath : RULE_FILES_PRIORITY_ARRAY) {
            if (resolver.getResource(strCurrentPath) == null) continue;
            strRetVal = strCurrentPath;
            break;
        }
        if (ETC_WORKFLOW_MODELS_TRANSLATION_TRANSLATION_RULES_XML.equals(strRetVal)) {
            LOGGER.info("falling back to {} path, which is obselete, please upgrade this path", strRetVal);
        }
        return strRetVal;
    }

    public static MachineTranslationCloudConfig getMachineCloudConfigFromResource(MachineTranslationUtil mtu, Resource pageResource) {
        MachineTranslationCloudConfig retVal = null;
        if (mtu != null) {
            retVal = mtu.getAppliedMachineTranslationCloudConfigs(pageResource);
        }
        return retVal;
    }

    public static boolean isAddAssetAllowedByCloudConfig(MachineTranslationCloudConfig machineCloudConfig) {
        if (machineCloudConfig != null) {
            return machineCloudConfig.isTranslateAssetsAllowedForAssets() || machineCloudConfig.isTranslateMetadataForAssets() || machineCloudConfig.isTranslateTagsForAssets();
        }
        return true;
    }

    public static boolean isAddEmbeddedAssetsAllowedByConfig(MachineTranslationCloudConfig machineCloudConfig) {
        if (machineCloudConfig != null) {
            return machineCloudConfig.getEmbeddedAssetsWorkflow() != MachineTranslationCloudConfig.TranslationEmbeddedAssetsWorkflow.DO_NOT_TRANSLATE;
        }
        return true;
    }
}

