/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.localization;

import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveCopy;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.smartling.aem.connector.automation.impl.LiveCopyManager;
import com.smartling.aem.connector.automation.impl.wcm.localization.LiveCopyException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={LiveCopyManager.class})
public class LiveCopyManagerImpl
implements LiveCopyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiveCopyManagerImpl.class);

    @Override
    public void endLiveRelationship(ResourceResolver resolver, String targetPath) throws LiveCopyException {
        if (StringUtils.isBlank((CharSequence)targetPath)) {
            LOGGER.error("Couldn't end live relation ship for blank target path");
            return;
        }
        Resource target = resolver.getResource(targetPath);
        if (target == null) {
            LOGGER.error("Couldn't find target path=\"{}\"", (Object)targetPath);
            return;
        }
        LiveRelationshipManager liveRelationshipManager = (LiveRelationshipManager)resolver.adaptTo(LiveRelationshipManager.class);
        try {
            String relativePath;
            LiveCopy liveCopy;
            if (liveRelationshipManager != null && (liveCopy = liveRelationshipManager.getLiveCopy(target)) != null && (relativePath = LiveCopyManagerImpl.relativePath(liveCopy.getPath(), targetPath)) != null) {
                liveCopy.addExclusion(relativePath);
            }
            this.forceDetachLiveCopy(target);
        }
        catch (WCMException e) {
            throw new LiveCopyException("Couldn't end live copy relationship", e);
        }
    }

    public void forceDetachLiveCopy(Resource target) throws LiveCopyException {
        Node node = (Node)target.adaptTo(Node.class);
        if (node != null) {
            try {
                this.detachLiveCopy(node);
                node.getSession().save();
                LOGGER.debug("Detached Resource at {} from LiveRelationship", (Object)target.getPath());
            }
            catch (RepositoryException e) {
                throw new LiveCopyException("Couldn't detach live copy", e);
            }
        }
    }

    private void detachLiveCopy(Node targetNode) throws LiveCopyException {
        try {
            this.removeLiveRelationshipMarker(targetNode);
            if (targetNode.hasNode("cq:LiveSyncAction")) {
                Node actions = targetNode.getNode("cq:LiveSyncAction");
                actions.remove();
            }
            this.removeLiveCopyMarker(targetNode);
            this.removeRolloutMarker(targetNode);
            NodeIterator ni = targetNode.getNodes();
            while (ni.hasNext()) {
                Node child = ni.nextNode();
                this.detachLiveCopy(child);
            }
        }
        catch (RepositoryException e) {
            throw new LiveCopyException("Unable to remove Live Copy markers", e);
        }
    }

    private void removeRolloutMarker(Node targetNode) throws RepositoryException {
        if (targetNode.hasProperty("cq:lastRolledout")) {
            targetNode.getProperty("cq:lastRolledout").remove();
        }
        if (targetNode.hasProperty("cq:lastRolledoutBy")) {
            targetNode.getProperty("cq:lastRolledoutBy").remove();
        }
        if (targetNode.isNodeType("cq:LiveRelationship")) {
            targetNode.removeMixin("cq:LiveRelationship");
        }
    }

    private void removeLiveCopyMarker(Node targetNode) throws RepositoryException {
        if (targetNode.isNodeType("cq:LiveSync")) {
            targetNode.removeMixin("cq:LiveSync");
            LOGGER.debug("Removed mixin type from storage {}", (Object)targetNode.getPath());
        }
        if (targetNode.hasNode("cq:LiveSyncConfig")) {
            targetNode.getNode("cq:LiveSyncConfig").remove();
            LOGGER.debug("Removed config node {}", (Object)targetNode.getPath());
        }
    }

    private void removeLiveRelationshipMarker(Node targetNode) throws RepositoryException {
        if (targetNode.isNodeType("cq:LiveSyncCancelled")) {
            targetNode.removeMixin("cq:LiveSyncCancelled");
        }
        if (targetNode.hasProperty("cq:isCancelledForChildren")) {
            targetNode.getProperty("cq:isCancelledForChildren").remove();
        }
        if (targetNode.isNodeType("cq:PropertyLiveSyncCancelled")) {
            targetNode.removeMixin("cq:PropertyLiveSyncCancelled");
            if (targetNode.hasProperty("cq:propertyInheritanceCancelled")) {
                targetNode.getProperty("cq:propertyInheritanceCancelled").remove();
            }
        }
    }

    private static String relativePath(String parent, String child) {
        if (StringUtils.isEmpty((CharSequence)parent) || StringUtils.isEmpty((CharSequence)child) || !parent.startsWith("/") || !child.startsWith("/") || !StringUtils.startsWith((CharSequence)child, (CharSequence)parent)) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)parent, (CharSequence)child)) {
            return null;
        }
        return child.substring(parent.length() + 1);
    }
}

