/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.localization;

import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.LiveCopyManager;
import com.smartling.aem.connector.automation.impl.OrderResolver;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.wcm.localization.LanguageCopyException;
import com.smartling.aem.connector.automation.impl.wcm.localization.LanguageCopyManagerImpl;
import com.smartling.aem.connector.automation.ui.SmartlingDialogConfiguration;
import com.smartling.aem.connector.core.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PageLanguageCopyManager.class})
public class PageLanguageCopyManagerImpl
extends LanguageCopyManagerImpl
implements PageLanguageCopyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageLanguageCopyManagerImpl.class);
    @Reference
    private LanguageManager languageManager;
    @Reference
    private LiveCopyManager liveCopyManager;
    @Reference
    private OrderResolver orderResolver;
    @Reference
    private SmartlingDialogConfiguration smartlingDialogConfiguration;

    @Override
    public Iterable<LanguageCopyManager.LanguageCopy> findLanguageCopies(ResourceResolver resourceResolver, String path) {
        Collection languageResourceRoots;
        Collection collection = languageResourceRoots = this.smartlingDialogConfiguration.respectContent() ? this.languageManager.getLanguageRootResources(resourceResolver, path, true) : this.languageManager.getLanguageRootResources(resourceResolver, path);
        if (this.smartlingDialogConfiguration.areLanguageRootSiblingsOnly()) {
            try {
                String sourceLanguageRoot = languageResourceRoots.stream().map(Resource::getPath).filter(resourcePath -> StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)resourcePath)).findFirst().orElseThrow(() -> new LanguageCopyException("No language root for source page"));
                String sourceLanguageRootParent = StringUtils.substringBeforeLast((String)sourceLanguageRoot, (String)"/");
                languageResourceRoots = languageResourceRoots.stream().filter(resource -> StringUtils.substringBeforeLast((String)resource.getPath(), (String)"/").equals(sourceLanguageRootParent)).collect(Collectors.toList());
            }
            catch (LanguageCopyException ex) {
                LOGGER.error("Failed to omit language roots on different levels", (Throwable)ex);
            }
        }
        languageResourceRoots = languageResourceRoots.stream().map(this::skipRootContentResource).collect(Collectors.toList());
        return languageResourceRoots.stream().map(this.toLanguageCopy(resourceResolver, path)).filter(Predicates.not(PageLanguageCopyManagerImpl.equalBy(PageLanguageCopyManagerImpl.languageCopyPath(), path))).collect(Collectors.toList());
    }

    @Override
    public Language getLanguage(ResourceResolver resourceResolver, String path) {
        Resource languageRoot = this.smartlingDialogConfiguration.respectContent() ? this.languageManager.getLanguageRootResource(resourceResolver.resolve(path), true) : this.languageManager.getLanguageRootResource(resourceResolver.resolve(path));
        if ((languageRoot = this.skipRootContentResource(languageRoot)) == null || ResourceUtil.isNonExistingResource((Resource)languageRoot)) {
            return null;
        }
        return this.createFromLanguageRoot(languageRoot);
    }

    @Override
    public void createLanguageCopy(ResourceResolver resourceResolver, String sourcePath, String targetPath, boolean isDeep) throws Exception {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Resource sourcePage = resourceResolver.getResource(sourcePath);
        Resource targetPage = pageManager.copy(sourcePage, targetPath, null, !isDeep, false);
        this.liveCopyManager.endLiveRelationship(resourceResolver, targetPath);
        Resource targetParent = targetPage.getParent();
        Node targetParentNode = (Node)targetParent.adaptTo(Node.class);
        if (targetParentNode.getPrimaryNodeType().hasOrderableChildNodes()) {
            String nextPageName = this.orderResolver.getNextPageName(sourcePage, targetPage);
            pageManager.order(targetPage, nextPageName);
        }
    }

    @Override
    public Date getLastModified(ResourceResolver resourceResolver, String path) {
        return PageLanguageCopyManagerImpl.getProperty(resourceResolver, path, Date.class, "cq:lastModified");
    }

    @Override
    public List<String> getSubpagesPaths(ResourceResolver resourceResolver, String sourcePath, Set<String> excludedSubpagesPaths) {
        if (excludedSubpagesPaths.contains(sourcePath)) {
            return Collections.emptyList();
        }
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        ArrayList<String> childrenPaths = new ArrayList<String>();
        childrenPaths.add(sourcePath);
        List<String> checkPaths = Collections.singletonList(sourcePath);
        while (!checkPaths.isEmpty()) {
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String checkPath : checkPaths) {
                Page sourcePage = pageManager.getPage(checkPath);
                Iterator it = sourcePage.listChildren();
                while (it.hasNext()) {
                    String newPath = ((Page)it.next()).getPath();
                    if (excludedSubpagesPaths.contains(newPath)) continue;
                    newPaths.add(newPath);
                }
            }
            checkPaths = newPaths;
            childrenPaths.addAll(newPaths);
        }
        return childrenPaths;
    }

    private Function<Resource, LanguageCopyManager.LanguageCopy> toLanguageCopy(ResourceResolver resourceResolver, String path) {
        Resource pathResource = resourceResolver.resolve(path);
        Resource thisLanguageRoot = this.skipRootContentResource(this.smartlingDialogConfiguration.respectContent() ? this.languageManager.getLanguageRootResource(pathResource, true) : this.languageManager.getLanguageRootResource(pathResource));
        return languageRoot -> {
            String languageCopyPath = path.replace(thisLanguageRoot.getPath(), languageRoot.getPath());
            Language language = this.createFromLanguageRoot((Resource)languageRoot);
            boolean exist = resourceResolver.getResource(languageCopyPath) != null;
            Date lastModified = this.getLastModified(resourceResolver, languageCopyPath);
            LanguageCopyManager.LanguageCopy languageCopy = new LanguageCopyManager.LanguageCopy(languageCopyPath, language, exist);
            languageCopy.setLastModified(lastModified);
            Date lastTranslationUpdate = PageLanguageCopyManagerImpl.getProperty(resourceResolver, languageCopyPath, Date.class, "cq:lastTranslationUpdate");
            languageCopy.setLastTranslationApplied(lastTranslationUpdate);
            return languageCopy;
        };
    }

    private Language createFromLanguageRoot(Resource languageRoot) {
        String languageCode;
        String locale = this.getCqLanguage(languageRoot);
        if (this.areLanguageCodesEqual(locale, languageCode = this.getLanguageCode(this.languageManager, languageRoot))) {
            locale = languageCode;
        }
        return Language.create(locale, PageLanguageCopyManagerImpl.getLanguageDisplayName(languageRoot.getResourceResolver(), locale));
    }

    private boolean areLanguageCodesEqual(String lang1, String lang2) {
        String lang1WithHyphen = lang1.replace("_", "-");
        String lang2WithHyphen = lang2.replace("_", "-");
        return lang1WithHyphen.equalsIgnoreCase(lang2WithHyphen);
    }

    private String getLanguageCode(LanguageManager languageManager, Resource languageRoot) {
        String languageCode = this.getLanguageRootLocale(languageManager, languageRoot);
        String targetLanguageRootName = languageRoot.getName();
        if (languageCode == null || this.areLanguageCodesEqual(languageCode, targetLanguageRootName)) {
            languageCode = targetLanguageRootName;
        }
        return languageCode;
    }

    private String getLanguageRootLocale(LanguageManager languageManager, Resource languageRoot) {
        com.day.cq.commons.Language language;
        ValueMap props;
        if (null == languageRoot) {
            return null;
        }
        if (!languageRoot.getPath().equals("/") && (props = (ValueMap)languageRoot.adaptTo(ValueMap.class)) != null) {
            if (((Boolean)props.get("jcr:content/cq:isLanguageRoot", (Object)false)).booleanValue()) {
                com.day.cq.commons.Language language2;
                String iso = (String)props.get("jcr:content/jcr:language", (Object)"");
                com.day.cq.commons.Language language3 = language2 = iso.isEmpty() ? null : LanguageUtil.getLanguage((String)iso);
                if (language2 == null) {
                    LOGGER.warn("Invalid iso code stored in {}: {}", (Object)languageRoot.getPath(), (Object)iso);
                } else {
                    return language2.getLocale().toString();
                }
            }
        }
        if ((language = LanguageUtil.getLanguage((String)languageRoot.getName())) != null) {
            return languageRoot.getName();
        }
        return null;
    }
}

