/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.project;

import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationObject;
import com.smartling.aem.connector.automation.impl.TranslationProject;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobDetails;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationObjectDetails;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TranslationDetailsManager.class})
public class TranslationDetailsManager {
    @Reference
    private TranslationProjectManager translationProjectManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    public TranslationObjectDetails getTranslationObjectDetails(String translationJobId, String translationObjectSourcePath) throws SmartlingException {
        TranslationObjectDetails[] translationObjectDetails = new TranslationObjectDetails[1];
        this.consumeTranslationProject(translationJobId, translationProject -> {
            TranslationJob translationJob = this.findTranslationJob(translationJobId, translationProject);
            String translationObjectFileType = null;
            if (StringUtils.isNotBlank((CharSequence)translationObjectSourcePath)) {
                TranslationObject translationObject = translationJob.getTranslationObjects().stream().filter(translationObj -> StringUtils.equalsIgnoreCase((CharSequence)translationObj.getSourcePath(), (CharSequence)translationObjectSourcePath)).findAny().orElseThrow(() -> new SmartlingException(String.format("Couldn't find translation object by sourcePath=\"%s\"", translationObjectSourcePath)));
                translationObjectFileType = translationObject.getTranslationFileType();
            }
            String sourceLanguage = translationProject.getSourceLanguage().getCode();
            String configSourceLocaleCode = translationProject.getConfigSourceLocaleCode();
            String targetLanguage = translationJob.getTargetLanguage();
            String batchUid = translationProject.getBatchUid();
            translationObjectDetails[0] = TranslationObjectDetails.builder().translationObjectSourcePath(translationObjectSourcePath).translationJobId(translationJobId).translationObjectFileType(translationObjectFileType).targetLanguage(targetLanguage).sourceLanguage(sourceLanguage).jobUid(translationProject.getJobUid()).batchUid(batchUid).configSourceLocaleCode(configSourceLocaleCode).projectUid(translationProject.getProjectUid()).accountUid(translationProject.getAccountUid()).autoAuthorize(translationProject.autoAuthorize()).localeWorkflows(translationProject.getLocaleWorkflows()).build();
        });
        return translationObjectDetails[0];
    }

    public void setTranslationProjectAccountUid(String translationJobId, String accountUid) throws SmartlingException {
        this.consumeTranslationProject(translationJobId, translationProject -> translationProject.setAccountUid(accountUid));
    }

    public void setTranslationProjectUid(String translationJobId, String projectUid) throws SmartlingException {
        this.consumeTranslationProject(translationJobId, translationProject -> translationProject.setProjectUid(projectUid));
    }

    public void setTranslationProjectJobUid(String translationJobId, String jobUid) throws SmartlingException {
        this.consumeTranslationProject(translationJobId, translationProject -> translationProject.setJobUid(jobUid));
    }

    public void setTranslationProjectBatchUid(String translationJobId, String batchUid) throws SmartlingException {
        this.consumeTranslationProject(translationJobId, translationProject -> translationProject.setBatchUid(batchUid));
    }

    public TranslationJobDetails getTranslationJobDetails(String translationJobId) throws SmartlingException {
        TranslationJobDetails[] translationJobDetails = new TranslationJobDetails[1];
        this.consumeTranslationProject(translationJobId, translationProject -> {
            TranslationJob translationJob = this.findTranslationJob(translationJobId, translationProject);
            List<String> translationJobIds = translationJob.getTranslationObjects().stream().map(TranslationObject::getId).filter(Objects::nonNull).collect(Collectors.toList());
            translationJobDetails[0] = TranslationJobDetails.builder().translationObjectIds(translationJobIds).targetLanguage(translationJob.getTargetLanguage()).configSourceLocaleCode(translationProject.getConfigSourceLocaleCode()).projectUid(translationProject.getProjectUid()).accountUid(translationProject.getAccountUid()).pseudo(translationProject.isPseudo()).build();
        });
        return translationJobDetails[0];
    }

    private TranslationJob findTranslationJob(String jobId, TranslationProject translationProject) throws SmartlingException {
        return translationProject.getTranslationJobs().stream().filter(job -> StringUtils.equals((CharSequence)jobId, (CharSequence)job.getJobId())).findFirst().orElseThrow(() -> new SmartlingException(String.format("Couldn't find translation job object for jobId='%s'", jobId)));
    }

    private void consumeTranslationProject(String translationJobId, TranslationProjectConsumer consumer) throws SmartlingException {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            TranslationProject translationProject = this.translationProjectManager.getProjectByTranslationJobId(resourceResolver, translationJobId);
            consumer.apply(translationProject);
        }
        catch (TranslationProjectException | LoginException e) {
            throw new SmartlingException(String.format("Couldn't find translation project for jobId=\"%s\"", translationJobId), e);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    @FunctionalInterface
    static interface TranslationProjectConsumer {
        public void apply(TranslationProject var1) throws SmartlingException;
    }
}

