/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class})
public class DetermineTranslationMethodProcess
extends ContextAwareWorkflowProcess
implements WorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetermineTranslationMethodProcess.class);
    public static final String MACHINE_TRANSLATION_VALUE = "MACHINE";
    private static final String DAM_ROOT_FOLDER = "/content/dam";
    @Reference
    private ServletUtils servletUtils;

    @Override
    protected void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        if (resourceResolver == null) {
            LOGGER.warn("Could not adapt WorkflowSession to ResourceResolver");
            return;
        }
        String payloadPath = (String)workItem.getWorkflowData().getPayload();
        if (payloadPath == null) {
            LOGGER.warn("Workflow payload path is null");
            return;
        }
        try {
            MachineTranslationCloudConfig machineTranslationCloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, payloadPath, MachineTranslationCloudConfig.class);
            if (machineTranslationCloudConfig == null) {
                LOGGER.debug("No machine translation cloud config found for path: {}", (Object)payloadPath);
                return;
            }
            boolean isMachineTranslation = this.checkIfMachineTranslation(payloadPath, machineTranslationCloudConfig);
            if (isMachineTranslation) {
                workItem.getWorkflowData().getMetaDataMap().put((Object)"translationMethod", (Object)MACHINE_TRANSLATION_VALUE);
                LOGGER.info("Translation method set to MACHINE for payload: {}", (Object)payloadPath);
            } else {
                LOGGER.debug("Translation method is not MACHINE for payload: {}", (Object)payloadPath);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error determining translation method for path: " + payloadPath, (Throwable)e);
            throw new WorkflowException("Failed to determine translation method", (Throwable)e);
        }
    }

    private boolean checkIfMachineTranslation(String path, MachineTranslationCloudConfig machineTranslationCloudConfig) {
        if (path.startsWith(DAM_ROOT_FOLDER)) {
            return machineTranslationCloudConfig.getDefaultTranslationProviderWorkflowForAssets() == MachineTranslationCloudConfig.TranslationProviderWorkflow.MACHINE_TRANSLATION;
        }
        return machineTranslationCloudConfig.getDefaultTranslationProviderWorkflowForSites() == MachineTranslationCloudConfig.TranslationProviderWorkflow.MACHINE_TRANSLATION;
    }
}

