/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClient;
import com.smartling.aem.connector.core.impl.integration.SmartlingPlatformClientFactory;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class})
public class ExecuteBatchProcess
extends ContextAwareWorkflowProcess
implements WorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteBatchProcess.class);
    @Reference
    private SmartlingPlatformClientFactory smartlingPlatformClientFactory;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        SmartlingCloudConfig cloudConfig = this.getSmartlingCloudConfig(workItem, workflowSession);
        JobWorkflowParameters jobWorkflowParameters = new JobWorkflowParameters(workItem);
        String batchUid = jobWorkflowParameters.getBatchUid();
        int uploadedFilesCount = jobWorkflowParameters.getUploadedFileCount();
        if (uploadedFilesCount == 0) {
            LOGGER.info("Can't execute batch due to no uploaded files for batchUid=\"{}\" for projectId=\"{}\"", (Object)batchUid, (Object)cloudConfig.getProjectId());
            return;
        }
        try (SmartlingPlatformClient platformClient = this.smartlingPlatformClientFactory.createClient(cloudConfig);){
            platformClient.executeBatch(cloudConfig.getProjectId(), batchUid, jobWorkflowParameters.getLocaleWorkflows());
            LOGGER.info("Executed batch with batchUid=\"{}\" for projectId=\"{}\"", (Object)batchUid, (Object)cloudConfig.getProjectId());
        }
        catch (RestApiRuntimeException e) {
            LOGGER.error("Failed to execute batchUid=\"{}\" for projectId=\"{}\"", new Object[]{batchUid, cloudConfig.getProjectId(), e});
            throw new WorkflowException((Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("General error on execute batch request for batchUid=\"{}\".", (Object)batchUid, (Object)e);
            throw new WorkflowException((Throwable)e);
        }
    }
}

