/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.smartling.aem.connector.automation.impl.FormLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.WcmWorkflows;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.SendForTranslationProcess;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.core.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowProcess.class})
public class SendFormForTranslationProcess
extends SendForTranslationProcess
implements WorkflowProcess {
    @Reference
    private WcmWorkflows wcmWorkflows;
    @Reference
    private FormLanguageCopyManager languageCopyManager;

    @Override
    protected void updateLanguageCopy(WorkflowSession workflowSession, WcmWorkflows.Parameters parameters) throws WorkflowException {
        this.wcmWorkflows.prepareFormLanguageCopy(workflowSession, parameters);
    }

    @Override
    protected void putCustomWorkflowParams(WcmWorkflows.Parameters parameters, ResourceResolver resourceResolver, WorkItem workItem) {
        JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
        Language sourceLanguage = this.languageCopyManager.getLanguage(resourceResolver, workflowParameters.getSourcePathList().get(0));
        String payload = (String)workItem.getWorkflowData().getPayload();
        List<LanguageCopyManager.LanguageCopy> languageCopies = this.getLanguageCopies(resourceResolver, workflowParameters.getTargetLocaleCodes(), payload);
        parameters.setInitiatorUserID(workItem.getWorkflow().getInitiator());
        parameters.setLanguageCopies(languageCopies);
        parameters.setSourceLanguage(sourceLanguage.getCode());
        parameters.setSourcePaths(Collections.singletonList(payload));
    }

    private List<LanguageCopyManager.LanguageCopy> getLanguageCopies(ResourceResolver resourceResolver, Collection<String> targetLocales, String sourcePath) {
        return StreamSupport.stream(this.languageCopyManager.findLanguageCopies(resourceResolver, sourcePath).spliterator(), false).filter(WorkflowUtil.byLocaleCode(Predicates.in(targetLocales))).collect(Collectors.toList());
    }
}

