/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class})
public class UpdateJobProcess
extends ContextAwareWorkflowProcess
implements WorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateJobProcess.class);
    @Reference
    private JobApiClientFactory clientFactory;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        JobWorkflowParameters parameters = new JobWorkflowParameters(workItem);
        if (parameters.getCustomFields() == null || parameters.getCustomFields().isEmpty()) {
            return;
        }
        SmartlingCloudConfig config = this.getSmartlingCloudConfig(workItem, workflowSession);
        try (JobApiClient jobApiClient = this.clientFactory.createClient(config);){
            Job jobInfo = jobApiClient.loadJob(parameters.getJobUid());
            jobApiClient.updateJob(jobInfo.getUid(), jobInfo.getName(), jobInfo.getDescription(), this.parseDueDate(jobInfo.getDueDate()), parameters.getCustomFields());
        }
        catch (SmartlingException e) {
            LOGGER.error("Couldn't update Smartling translation job jobUid={}", (Object)parameters.getJobUid(), (Object)e);
            throw new WorkflowException(String.format("Couldn't update Smartling translation job jobUid=%s", parameters.getJobUid()), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("General error on updating job by jobUid=\"{}\".", (Object)parameters.getJobUid(), (Object)e);
            throw new WorkflowException((Throwable)e);
        }
    }

    private Date parseDueDate(String dueDate) {
        if (StringUtils.isBlank((CharSequence)dueDate)) {
            return null;
        }
        try {
            SimpleDateFormat m_ISO8601Local = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            m_ISO8601Local.setTimeZone(TimeZone.getTimeZone("GMT"));
            return m_ISO8601Local.parse(dueDate);
        }
        catch (ParseException e) {
            LOGGER.error("Couldn't parse dueDate={}", (Object)dueDate, (Object)e);
            return null;
        }
    }
}

