/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.granite.workflow.exec.WorkItem;
import com.day.cq.wcm.api.Page;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import java.util.Calendar;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowUtil.class);

    private WorkflowUtil() {
    }

    static boolean isWorkflowAborted(WorkItem workItem) {
        return "ABORTED".equalsIgnoreCase(workItem.getWorkflow().getState());
    }

    public static Predicate<LanguageCopyManager.LanguageCopy> byLocaleCode(final Predicate<String> localeCodesFilter) {
        return new Predicate<LanguageCopyManager.LanguageCopy>(){

            @Override
            public boolean test(LanguageCopyManager.LanguageCopy languageCopy) {
                return WorkflowUtil.localeCodeOfLanguageCopy().andThen(localeCodesFilter::test).apply(languageCopy);
            }
        };
    }

    static Function<LanguageCopyManager.LanguageCopy, Language> languageOfLanguageCopy() {
        return new Function<LanguageCopyManager.LanguageCopy, Language>(){

            @Override
            public Language apply(LanguageCopyManager.LanguageCopy languageCopy) {
                return languageCopy.getLanguage();
            }
        };
    }

    private static Function<LanguageCopyManager.LanguageCopy, String> localeCodeOfLanguageCopy() {
        return WorkflowUtil.codeOfLanguage().compose(WorkflowUtil.languageOfLanguageCopy());
    }

    private static Function<Language, String> codeOfLanguage() {
        return new Function<Language, String>(){

            @Override
            public String apply(Language language) {
                return language.getCode();
            }
        };
    }

    public static String getPayloadTitle(Resource resource) {
        Page page = (Page)resource.adaptTo(Page.class);
        if (page != null) {
            return page.getTitle();
        }
        ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (contentFragment != null) {
            return contentFragment.getTitle();
        }
        return resource.getName();
    }

    private static void setLastModified(Resource resource, Calendar date) {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (properties == null) {
            LOGGER.warn("Resource path=\"{}\" is not modifiable as ValueMap", (Object)resource.getPath());
            WorkflowUtil.setNodeLastModified(resource, date);
            return;
        }
        WorkflowUtil.setLastModifiedValue(properties, date);
    }

    private static void setNodeLastModified(Resource contentResource, Calendar date) {
        Node node = (Node)contentResource.adaptTo(Node.class);
        if (node == null) {
            LOGGER.warn("Resource path=\"{}\" is not modifiable as JCR Node", (Object)contentResource.getPath());
            return;
        }
        try {
            if (node.hasProperty("cq:lastModified")) {
                node.setProperty("cq:lastModified", date);
            }
            if (node.hasProperty("jcr:lastModified")) {
                node.setProperty("jcr:lastModified", date);
            }
        }
        catch (RepositoryException e) {
            LOGGER.error("Cannot get access to node path=\"{}\"", (Object)contentResource.getPath(), (Object)e);
        }
    }

    private static void setLastModifiedValue(ModifiableValueMap properties, Calendar date) {
        if (properties == null) {
            return;
        }
        if (properties.containsKey((Object)"cq:lastModified")) {
            properties.put((Object)"cq:lastModified", (Object)date);
        }
        if (properties.containsKey((Object)"jcr:lastModified")) {
            properties.put((Object)"jcr:lastModified", (Object)date);
        }
    }

    public static void setContentLastModifiedNow(Resource payloadResource) {
        Resource sourceContentResource = payloadResource.getChild("jcr:content");
        if (sourceContentResource != null) {
            WorkflowUtil.setLastModified(sourceContentResource, Calendar.getInstance());
        }
    }

    public static void setContentLastModifiedNow(Page payloadPage) {
        Resource sourceContentResource = payloadPage.getContentResource();
        WorkflowUtil.setLastModified(sourceContentResource, Calendar.getInstance());
    }
}

