/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.day.cq.commons.LanguageUtil;
import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.FormLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.JobDetail;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.TargetLocale;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/jobs/detail"})
public class JobDetailServlet
extends SmartlingBaseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobDetailServlet.class);
    public static final String NO_MAPPINGS_ERROR_MESSAGE_FORMAT = "There are no mappings for smartlingLocale=\"%s\"";
    public static final String MULTIPLE_MAPPINGS_ERROR_MESSAGE_FORMAT = "There are multiple mappings and language roots for smartlingLocale=\"%s\"";
    public static final String NO_CONFIG_FOR_PROJECT = "There is no configuration for project \"%s\"";
    @Reference
    private JobApiClientFactory clientFactory;
    @Reference
    private CloudConfigLocator cloudConfigLocator;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;
    @Reference
    private FormLanguageCopyManager formLanguageCopyManager;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        try {
            String path = JobDetailServlet.getMandatoryParameter(request, "path", "Mandatory path parameter is missing");
            String jobUid = JobDetailServlet.getMandatoryParameter(request, "uid", "Mandatory job UID parameter is missing");
            String projectUid = request.getParameter("projectUid");
            path = StringUtils.substringBefore((String)path, (String)";");
            LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)"/content/dam") ? this.assetLanguageCopyManager : (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)"/content/forms") ? this.formLanguageCopyManager : this.pageLanguageCopyManager);
            Resource resource = resourceResolver.resolve(path);
            if (ResourceUtil.isNonExistingResource((Resource)resource)) {
                throw new IllegalArgumentException(String.format("Resource '%s' can not be found", path));
            }
            SmartlingCloudConfig cloudConfig = this.getSmartlingConfig(resource);
            cloudConfig = this.cloudConfigResolver.getConfigByResource(cloudConfig, resource, projectUid);
            if (StringUtils.isNotBlank((CharSequence)projectUid) && !StringUtils.equalsIgnoreCase((CharSequence)cloudConfig.getProjectId(), (CharSequence)projectUid)) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, String.format(NO_CONFIG_FOR_PROJECT, projectUid));
                return;
            }
            Iterable<LanguageCopyManager.LanguageCopy> languageCopies = languageCopyManager.findLanguageCopies(resourceResolver, path);
            JobDetail job = this.loadJobDetails(jobUid, cloudConfig, languageCopies);
            JobDetailServlet.writeJson(response, job);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to load job details:", (Throwable)e);
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to load job details:", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private JobDetail loadJobDetails(String jobUid, SmartlingCloudConfig cloudConfig, Iterable<LanguageCopyManager.LanguageCopy> languageCopies) throws SmartlingException {
        Job job;
        try (JobApiClient client = this.clientFactory.createClient(cloudConfig);){
            job = client.loadJob(jobUid);
        }
        catch (Exception ex) {
            throw new SmartlingException("Couldn't get job for jobUid=\"" + jobUid + "\".", ex);
        }
        JobDetail jobDetail = new JobDetail();
        jobDetail.setDueDate(job.getDueDate());
        jobDetail.setName(job.getName());
        jobDetail.setState(job.getState());
        jobDetail.setCustomFields(job.getCustomFields());
        Set existingLocales = StreamSupport.stream(languageCopies.spliterator(), false).map(languageCopy -> languageCopy.getLanguage().getCode()).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
        Collection targetLocaleIds = job.getTargetLocaleIds().stream().map(this.getAdobeLocales(cloudConfig, existingLocales)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        Set<TargetLocale> targetLocales = targetLocaleIds.stream().map(targetLocale -> {
            String targetLocaleName = LanguageUtil.getLanguage((String)targetLocale).getLocale().getDisplayName(Locale.ENGLISH);
            return new TargetLocale((String)targetLocale, targetLocaleName);
        }).collect(Collectors.toSet());
        jobDetail.setTargetLocales(targetLocales);
        return jobDetail;
    }

    private Function<String, String> getAdobeLocales(SmartlingCloudConfig cloudConfig, Set<String> existingLocales) {
        return smartlingLocale -> {
            TreeMap smartlingToAdobeLocales = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            cloudConfig.getLanguageMapping().forEach((key, value) -> {
                Set<String> set = smartlingToAdobeLocales.containsKey(value) ? (Set)smartlingToAdobeLocales.get(value) : new TreeSet(String.CASE_INSENSITIVE_ORDER);
                set.add((String)key);
                smartlingToAdobeLocales.put(value, set);
            });
            Set adobeLocales = (Set)smartlingToAdobeLocales.get(smartlingLocale);
            if (adobeLocales == null) {
                adobeLocales = Collections.emptySet();
            }
            if (adobeLocales.isEmpty()) {
                throw new IllegalArgumentException(String.format(NO_MAPPINGS_ERROR_MESSAGE_FORMAT, smartlingLocale));
            }
            List adobeExistingLocales = adobeLocales.stream().filter(existingLocales::contains).collect(Collectors.toList());
            if (adobeExistingLocales.size() > 1) {
                throw new IllegalArgumentException(String.format(MULTIPLE_MAPPINGS_ERROR_MESSAGE_FORMAT, smartlingLocale));
            }
            return adobeExistingLocales.isEmpty() ? null : (String)adobeExistingLocales.iterator().next();
        };
    }

    private SmartlingCloudConfig getSmartlingConfig(Resource resource) {
        SmartlingCloudConfig cloudConfig = this.cloudConfigLocator.getCloudConfigAppliedOnResource(resource, SmartlingCloudConfig.class);
        if (cloudConfig == null) {
            throw new IllegalArgumentException("The resource=\"" + resource.getPath() + "\" does not have any Smartling Cloud Config associated with it");
        }
        return cloudConfig;
    }
}

