/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.smartling.aem.connector.automation.impl.ProjectCustomFieldsProvider;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.CustomField;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/project/custom-fields"})
public class ProjectCustomFieldServlet
extends SmartlingBaseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectCustomFieldServlet.class);
    @Reference
    private ProjectCustomFieldsProvider projectCustomFieldsProvider;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        try {
            String path = ProjectCustomFieldServlet.getMandatoryParameter(request, "path", "Mandatory path parameter is missing");
            String projectUid = request.getParameter("projectUid");
            path = StringUtils.substringBefore((String)path, (String)";");
            Resource resource = resourceResolver.resolve(path);
            if (ResourceUtil.isNonExistingResource((Resource)resource)) {
                throw new IllegalArgumentException(String.format("Resource '%s' can not be found", path));
            }
            List<CustomField> customFields = this.projectCustomFieldsProvider.getAssignedCustomFields(resource, projectUid);
            ProjectCustomFieldServlet.writeJson(response, customFields);
        }
        catch (IllegalArgumentException e) {
            response.sendError(400, e.getMessage());
        }
        catch (SmartlingException e) {
            LOGGER.error("Failed to load project custom fields:", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }
}

