/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameterMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Component(service={Filter.class}, property={"sling.filter.scope=REQUEST", "sling.filter.pattern=/services/smartling/(jobs|job|cloud|target).*", "service.ranking=2147483647"})
public class SmartlingMDCFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingMDCFilter.class);
    private static final String PROJECT_ID = "projectId";
    @Reference
    private ServletUtils servletUtils;

    public void init(FilterConfig filterConfig) {
        LOGGER.debug("Initializing SmartlingMDCFilter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        try {
            try {
                this.insertIntoMDC(slingRequest);
            }
            catch (Exception e) {
                LOGGER.warn("Can't init MDC for request {}", (Object)this.dumpParameterMap(slingRequest.getRequestParameterMap()), (Object)e);
            }
            chain.doFilter(request, response);
        }
        finally {
            this.clearMDC();
        }
    }

    private void clearMDC() {
        MDC.remove((String)PROJECT_ID);
    }

    private void insertIntoMDC(SlingHttpServletRequest request) throws SmartlingException {
        SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(request, request.getResourceResolver(), SmartlingCloudConfig.class);
        if (cloudConfig != null) {
            MDC.put((String)PROJECT_ID, (String)cloudConfig.getProjectId());
        }
    }

    public void destroy() {
    }

    private String dumpParameterMap(RequestParameterMap requestParameterMap) {
        return requestParameterMap.entrySet().stream().map(e -> (String)e.getKey() + " = " + Arrays.stream((Object[])e.getValue()).map(v -> "\"" + v.getString() + "\"").collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]"));
    }
}

