/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/translation/method"})
public class TranslationMethodServlet
extends SmartlingBaseServlet {
    public static final String NO_RESOURCE_ERROR_MESSAGE = "There is no resource";
    public static final String NO_CONFIG_ERROR_MESSAGE = "There is no Smartling config associated with the resource %s";
    public static final String DAM_ROOT_FOLDER = "/content/dam";
    public static final String CONTENT_ROOT_FOLDER = "/content";

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String payloadPath = this.servletUtils.getPayloadPath(request);
        if (StringUtils.isBlank((CharSequence)payloadPath)) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, NO_RESOURCE_ERROR_MESSAGE);
            return;
        }
        String firstPath = StringUtils.split((String)payloadPath, (String)";")[0];
        try {
            MachineTranslationCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, firstPath, MachineTranslationCloudConfig.class);
            if (cloudConfig == null) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, String.format(NO_CONFIG_ERROR_MESSAGE, firstPath));
                return;
            }
            String translationMethod = this.getTranslationMethod(firstPath, cloudConfig);
            TranslationMethodServlet.writeJson(response, Collections.singletonMap("translationMethod", translationMethod));
        }
        catch (Exception e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }

    private String getTranslationMethod(String path, MachineTranslationCloudConfig cloudConfig) {
        Object workflow = StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)DAM_ROOT_FOLDER) ? cloudConfig.getDefaultTranslationProviderWorkflowForAssets() : (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)CONTENT_ROOT_FOLDER) ? cloudConfig.getDefaultTranslationProviderWorkflowForSites() : null);
        if (workflow == MachineTranslationCloudConfig.TranslationProviderWorkflow.MACHINE_TRANSLATION) {
            return "MACHINE_TRANSLATION";
        }
        return "HUMAN_TRANSLATION";
    }
}

