/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.autoexecute;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.autoexecute.IsAutoExecuteValidator;
import com.smartling.aem.connector.automation.ui.validator.provider.TranslationProviderValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/auto/execute/validator"})
public class TranslationIntegrationValidationServlet
extends SmartlingBaseServlet {
    @Reference
    private IsAutoExecuteValidator isAutoExecuteValidator;
    @Reference
    private TranslationProviderValidator translationProviderValidator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        try {
            String path = this.servletUtils.getPayloadPath(request);
            path = StringUtils.substringBefore((String)path, (String)";");
            MachineTranslationCloudConfig machineTranslationCloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, MachineTranslationCloudConfig.class);
            if (machineTranslationCloudConfig == null) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, "Could not found machine translation cloud config for this page");
                return;
            }
            this.isAutoExecuteValidator.validate(machineTranslationCloudConfig);
            this.translationProviderValidator.validate(path, machineTranslationCloudConfig);
        }
        catch (SmartlingException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }
}

