/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.config;

import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.config.CloudConfigMatchValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/config/match/validator"})
public class CloudConfigMatchValidatorServlet
extends SmartlingBaseServlet {
    public static final String TARGET_LOCALE_CODES_PARAMETER_NAME = "targetLocaleCodes";
    @Reference
    private CloudConfigMatchValidator cloudConfigMatchValidator;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String[] targetLocaleCodesParam = request.getParameterValues(TARGET_LOCALE_CODES_PARAMETER_NAME);
        if (targetLocaleCodesParam == null) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, "Target locale codes are missing for checking parent page");
            return;
        }
        Set<String> targetLocaleCodes = Arrays.stream(targetLocaleCodesParam).filter(el -> !StringUtils.isEmpty((CharSequence)el)).map(String::toLowerCase).collect(Collectors.toSet());
        String payloadPath = this.servletUtils.getPayloadPath(request);
        String projectUid = request.getParameter("projectUid");
        try {
            List<String> payloadPaths = this.getPayloadPaths(payloadPath, this.assetLanguageCopyManager);
            for (String path : payloadPaths) {
                this.cloudConfigMatchValidator.validate(resourceResolver, path, targetLocaleCodes, projectUid);
            }
        }
        catch (SmartlingException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }
}

