/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.config;

import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/cloud/config/validator"})
public class CloudConfigValidatorServlet
extends SmartlingBaseServlet {
    public static final String NO_CONFIG_ERROR_MESSAGE = "There is no Smartling config associated with the resource %s";
    public static final String DIFFERENT_CONFIGS_ERROR_MESSAGE = "Smartling config associated with the resource \"%s\" is different than \"%s\"";
    public static final String NO_RESOURCE_ERROR_MESSAGE = "There is no resource";
    public static final String NO_CONFIG_FOR_PROJECT = "There is no configuration for project \"%s\", paths=\"%s\"";

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        SmartlingCloudConfig cloudConfig;
        String projectUid;
        String payloadPath = this.servletUtils.getPayloadPath(request);
        if (StringUtils.isBlank((CharSequence)payloadPath)) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 404, NO_RESOURCE_ERROR_MESSAGE);
            return;
        }
        SmartlingCloudConfig firstCloudConfig = null;
        String firstPath = null;
        for (String path : StringUtils.split((String)payloadPath, (String)";")) {
            SmartlingCloudConfig cloudConfig2 = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
            if (cloudConfig2 == null) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 404, String.format(NO_CONFIG_ERROR_MESSAGE, path));
                break;
            }
            if (firstCloudConfig == null) {
                firstCloudConfig = cloudConfig2;
                firstPath = path;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)firstCloudConfig.getPath(), (CharSequence)cloudConfig2.getPath())) continue;
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, String.format(DIFFERENT_CONFIGS_ERROR_MESSAGE, path, firstPath));
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)(projectUid = request.getParameter("projectUid"))) && !StringUtils.equalsIgnoreCase((CharSequence)(cloudConfig = firstCloudConfig.getForProject(projectUid)).getProjectId(), (CharSequence)projectUid)) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, String.format(NO_CONFIG_FOR_PROJECT, projectUid, payloadPath));
        }
    }
}

