/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.config;

import com.adobe.granite.crypto.CryptoSupport;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingCredentials;
import com.smartling.aem.connector.core.impl.config.SmartlingProjectCredentials;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/cloud/config"})
public class SaveCloudConfigServlet
extends SlingAllMethodsServlet {
    public static final String LOCALE_PARAMETER = "locale";
    public static final String PROJECT_ID_PARAMETER = "projectId";
    public static final String USER_IDENTIFIER_PARAMETER = "userIdentifier";
    public static final String TOKEN_SECRET_PARAMETER = "tokenSecret";
    public static final String CONFIG_PATH_PARAMETER = "configPath";
    public static final String MULTI_CONFIG_PROPERTY_NAME = "multiLocaleConfig";
    private Gson GSON = new GsonBuilder().create();
    public static final String RESPONSE_ERROR_FORMAT = "<div>  <div>  <div class=\"foundation-form-response-status-code\"></div>  <div>%s</div> </div> <div>  <div class=\"foundation-form-response-status-message\"></div>  <div>%s</div> </div> <div>  <div class=\"foundation-form-response-title\"></div>  <div>%s</div> </div></div>";
    @Reference
    private CryptoSupport cryptoSupport;

    protected void doPost(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException {
        try {
            String tokenSecret;
            String userIdentifier;
            Resource configContentResource;
            String configPath = request.getParameter(CONFIG_PATH_PARAMETER);
            if (StringUtils.isEmpty((CharSequence)configPath)) {
                String error = this.formatErrorResponse(400, "Configuration path was not specified");
                this.writeResponse(response, 400, error);
                return;
            }
            ResourceResolver resourceResolver = request.getResourceResolver();
            Resource configResource = resourceResolver.getResource(configPath);
            Resource resource = configContentResource = configResource == null ? null : configResource.getChild("jcr:content");
            if (configContentResource == null) {
                String error = this.formatErrorResponse(404, "Couldn't find configuration for saving");
                this.writeResponse(response, 404, error);
                return;
            }
            SmartlingCloudConfig config = (SmartlingCloudConfig)configResource.adaptTo(SmartlingCloudConfig.class);
            if (config == null) {
                String error = this.formatErrorResponse(404, "Configuration doesn't seem to be a Smartling config");
                this.writeResponse(response, 404, error);
                return;
            }
            if (config.isReadOnly()) {
                String error = this.formatErrorResponse(200, "Configuration is readonly");
                this.writeResponse(response, 200, error);
                return;
            }
            String[] locales = request.getParameterValues(LOCALE_PARAMETER);
            String[] projectIds = request.getParameterValues(PROJECT_ID_PARAMETER);
            String[] userIdentifiers = request.getParameterValues(USER_IDENTIFIER_PARAMETER);
            String[] tokenSecrets = request.getParameterValues(TOKEN_SECRET_PARAMETER);
            if (locales == null || locales.length < 1 || projectIds == null || projectIds.length < 1 || userIdentifiers == null || userIdentifiers.length < 1 || tokenSecrets == null || tokenSecrets.length < 1) {
                String error = this.formatErrorResponse(400, "You should specify one locale, project id, user identifier and token secret parameter");
                this.writeResponse(response, 400, error);
                return;
            }
            String projectId = StringUtils.trim((String)projectIds[0]);
            SmartlingProjectCredentials mainCredentials = this.getProjectCredentials(config, response, projectId, userIdentifier = StringUtils.trim((String)userIdentifiers[0]), tokenSecret = StringUtils.trim((String)tokenSecrets[0]), null);
            if (mainCredentials == null) {
                return;
            }
            int minLength = Math.min(Math.min(locales.length, projectIds.length), Math.min(userIdentifiers.length, tokenSecrets.length));
            ArrayList<SmartlingProjectCredentials> credentialsList = new ArrayList<SmartlingProjectCredentials>();
            for (int i = 1; i < minLength; ++i) {
                String credentialProjectId = StringUtils.trim((String)projectIds[i]);
                String credentialUserIdentifier = StringUtils.trim((String)userIdentifiers[i]);
                String credentialTokenSecret = StringUtils.trim((String)tokenSecrets[i]);
                String credentialLocale = StringUtils.trim((String)locales[i]);
                SmartlingProjectCredentials credentials = this.getProjectCredentials(config, response, credentialProjectId, credentialUserIdentifier, credentialTokenSecret = this.getTokenValue(credentialProjectId, credentialUserIdentifier, credentialTokenSecret, config.getForLocale(credentialLocale)), credentialLocale);
                if (credentials == null) {
                    return;
                }
                credentialsList.add(credentials);
            }
            Node configContentNode = (Node)configContentResource.adaptTo(Node.class);
            try {
                configContentNode.setProperty(MULTI_CONFIG_PROPERTY_NAME, this.GSON.toJson(credentialsList));
                configContentNode.setProperty(PROJECT_ID_PARAMETER, mainCredentials.getProjectId());
                configContentNode.setProperty(USER_IDENTIFIER_PARAMETER, mainCredentials.getUserIdentifier());
                configContentNode.setProperty(TOKEN_SECRET_PARAMETER, mainCredentials.getTokenSecret());
                resourceResolver.commit();
            }
            catch (RepositoryException | PersistenceException ex) {
                String error = this.formatErrorResponse(500, "Repository error on saving configuration");
                this.writeResponse(response, 500, error);
            }
        }
        catch (IOException ex) {
            throw new ServletException("General error on saving configuration", (Throwable)ex);
        }
    }

    private SmartlingProjectCredentials getProjectCredentials(SmartlingCloudConfig config, SlingHttpServletResponse response, String projectId, String userIdentifier, String tokenSecret, String locale) throws IOException {
        tokenSecret = this.getTokenValue(projectId, userIdentifier, tokenSecret, config);
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            String error = this.formatErrorResponse(400, "You should specify Project Id");
            this.writeResponse(response, 400, error);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)userIdentifier) || StringUtils.isEmpty((CharSequence)tokenSecret)) {
            String error = this.formatErrorResponse(400, "You should specify credentials: user identifier and token secret");
            this.writeResponse(response, 400, error);
            return null;
        }
        try {
            tokenSecret = this.cryptoSupport.protect(tokenSecret);
        }
        catch (Exception ex) {
            String error = this.formatErrorResponse(500, "Couldn't encrypt token secret");
            this.writeResponse(response, 500, error);
            return null;
        }
        return new SmartlingProjectCredentials(projectId, userIdentifier, tokenSecret, locale);
    }

    @Nullable
    private String getTokenValue(String projectId, String userIdentifier, String tokenSecret, SmartlingCredentials config) {
        if (config == null) {
            return tokenSecret;
        }
        if (StringUtils.isBlank((CharSequence)tokenSecret) && StringUtils.equals((CharSequence)projectId, (CharSequence)config.getProjectId()) && StringUtils.equals((CharSequence)userIdentifier, (CharSequence)config.getUserIdentifier())) {
            tokenSecret = config.getTokenSecret();
        }
        return tokenSecret;
    }

    private String formatErrorResponse(int statusCode, String message) {
        return String.format(RESPONSE_ERROR_FORMAT, statusCode, StringEscapeUtils.escapeHtml((String)message), "Error");
    }

    private void writeResponse(SlingHttpServletResponse response, int statusCode, String body) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        response.setStatus(statusCode);
        response.getWriter().write(body);
    }
}

