/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.locale;

import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.locale.TargetLocalesValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/target/locales/validator"})
public class TargetLocaleValidatorServlet
extends SmartlingBaseServlet {
    @Reference
    private TargetLocalesValidator targetLocalesValidator;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String[] targetLocaleCodesParam = request.getParameterValues("targetLocaleCodes");
        if (targetLocaleCodesParam == null) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, "Target locale codes are missing for checking parent page");
            return;
        }
        Set<String> targetLocaleCodes = Arrays.stream(request.getParameterValues("targetLocaleCodes")).filter(el -> !StringUtils.isEmpty((CharSequence)el)).collect(Collectors.toSet());
        try {
            String path = this.servletUtils.getPayloadPath(request);
            path = StringUtils.substringBefore((String)path, (String)";");
            SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
            if (cloudConfig == null) {
                return;
            }
            String projectUid = request.getParameter("projectUid");
            cloudConfig = this.cloudConfigResolver.getConfigByPath(cloudConfig, resourceResolver, path, projectUid);
            this.targetLocalesValidator.validate(cloudConfig, targetLocaleCodes);
        }
        catch (SmartlingException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }
}

