/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.page;

import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.page.TargetPageExistingValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/services/smartling/page/target/validator"})
public class TargetPageValidatorServlet
extends SmartlingBaseServlet {
    public static final String THERE_IS_NO_RESOURCE_ERROR_MESSAGE = "There is no resource for checking language copy";
    public static final String TARGET_LOCALE_CODES_MISSING_ERROR_MESSAGE = "Target locale codes are missing for checking parent page";
    @Reference
    private TargetPageExistingValidator targetParentPageValidator;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String payloadPath = this.servletUtils.getPayloadPath(request);
        if (StringUtils.isBlank((CharSequence)payloadPath)) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, THERE_IS_NO_RESOURCE_ERROR_MESSAGE);
            return;
        }
        String[] targetLocaleCodesParam = request.getParameterValues("targetLocaleCodes");
        if (targetLocaleCodesParam == null) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, TARGET_LOCALE_CODES_MISSING_ERROR_MESSAGE);
            return;
        }
        HashSet<String> targetLocaleCodes = new HashSet<String>(Arrays.asList(targetLocaleCodesParam));
        targetLocaleCodes.remove("");
        try {
            ResourceResolver finalResourceResolver = resourceResolver;
            for (String path2 : Stream.of(StringUtils.split((String)payloadPath, (String)";")).map(path -> this.getResource((String)path, finalResourceResolver).getPath()).collect(Collectors.toSet())) {
                this.validate(path2, resourceResolver, targetLocaleCodes);
            }
        }
        catch (SmartlingException | ResourceNotFoundException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }

    protected void validate(String path, ResourceResolver resourceResolver, Set<String> targetLocaleCodes) throws ResourceNotFoundException, SmartlingException {
        if (StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)"/content/forms")) {
            return;
        }
        LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)"/content/dam") ? this.assetLanguageCopyManager : this.pageLanguageCopyManager;
        Iterable<LanguageCopyManager.LanguageCopy> languageCopies = languageCopyManager.findLanguageCopies(resourceResolver, path);
        this.targetParentPageValidator.validate(languageCopies, targetLocaleCodes);
    }

    private Resource getResource(String path, ResourceResolver resourceResolver) {
        Resource resource = this.servletUtils.getResource(resourceResolver, path);
        if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
            throw new ResourceNotFoundException(path, THERE_IS_NO_RESOURCE_ERROR_MESSAGE);
        }
        return resource;
    }
}

